/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.sql;

import com.github.autostyle.FileSignature;
import com.github.autostyle.FormatterFunc;
import com.github.autostyle.FormatterProperties;
import com.github.autostyle.FormatterStep;
import com.github.autostyle.sql.DBeaverSQLFormatter;
import java.io.File;
import java.io.Serializable;

public class DBeaverSQLFormatterStep {
    private static final String NAME = "dbeaverSql";

    private DBeaverSQLFormatterStep() {
    }

    public static FormatterStep create(Iterable<File> files) {
        return FormatterStep.createLazy(NAME, () -> new State(files), State::createFormat);
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final FileSignature settingsSignature;

        State(Iterable<File> settingsFiles) throws Exception {
            this.settingsSignature = FileSignature.signAsList(settingsFiles);
        }

        FormatterFunc createFormat() throws Exception {
            FormatterProperties preferences = FormatterProperties.from(this.settingsSignature.files());
            DBeaverSQLFormatter dbeaverSqlFormatter = new DBeaverSQLFormatter(preferences.getProperties());
            return dbeaverSqlFormatter::format;
        }
    }
}

