/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.sql.dbeaver;

import com.github.autostyle.annotations.Internal;
import com.github.autostyle.sql.dbeaver.KeywordCase;
import com.github.autostyle.sql.dbeaver.SQLDialect;
import java.util.Properties;

@Internal
public class DBeaverSQLFormatterConfiguration {
    private static final String SQL_FORMATTER_KEYWORD_CASE = "sql.formatter.keyword.case";
    private static final String SQL_FORMATTER_STATEMENT_DELIMITER = "sql.formatter.statement.delimiter";
    private static final String SQL_FORMATTER_INDENT_TYPE = "sql.formatter.indent.type";
    private static final String SQL_FORMATTER_INDENT_SIZE = "sql.formatter.indent.size";
    private String statementDelimiters;
    private KeywordCase keywordCase;
    private String indentString;

    public DBeaverSQLFormatterConfiguration(Properties properties) {
        this.keywordCase = KeywordCase.valueOf(properties.getProperty(SQL_FORMATTER_KEYWORD_CASE, "UPPER"));
        this.statementDelimiters = properties.getProperty(SQL_FORMATTER_STATEMENT_DELIMITER, SQLDialect.INSTANCE.getScriptDelimiter());
        String indentType = properties.getProperty(SQL_FORMATTER_INDENT_TYPE, "space");
        int indentSize = Integer.parseInt(properties.getProperty(SQL_FORMATTER_INDENT_SIZE, "4"));
        this.indentString = this.getIndentString(indentType, indentSize);
    }

    private String getIndentString(String indentType, int indentSize) {
        char indentChar = indentType.equals("space") ? (char)' ' : '\t';
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < indentSize; ++i) {
            stringBuilder.append(indentChar);
        }
        return stringBuilder.toString();
    }

    String getStatementDelimiter() {
        return this.statementDelimiters;
    }

    String getIndentString() {
        return this.indentString;
    }

    KeywordCase getKeywordCase() {
        return this.keywordCase;
    }
}

