/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.sql.dbeaver;

import com.github.autostyle.sql.dbeaver.DBPKeywordType;
import com.github.autostyle.sql.dbeaver.Pair;
import com.github.autostyle.sql.dbeaver.SQLConstants;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;

class SQLDialect {
    private static final String[] DEFAULT_LINE_COMMENTS = new String[]{"--"};
    private static final String[] EXEC_KEYWORDS = new String[0];
    private static final String[][] DEFAULT_QUOTE_STRINGS = new String[][]{{"\"", "\""}};
    private TreeMap<String, DBPKeywordType> allKeywords = new TreeMap();
    private final TreeSet<String> functions = new TreeSet();
    private final TreeSet<String> types = new TreeSet();
    private Pair<String, String> multiLineComments = new Pair<String, String>("/*", "*/");
    static final SQLDialect INSTANCE = new SQLDialect();

    private SQLDialect() {
        this.loadStandardKeywords();
    }

    String[][] getIdentifierQuoteStrings() {
        return DEFAULT_QUOTE_STRINGS;
    }

    private String[] getExecuteKeywords() {
        return EXEC_KEYWORDS;
    }

    private void addSQLKeyword(String keyword) {
        this.allKeywords.put(keyword, DBPKeywordType.KEYWORD);
    }

    private void addKeywords(Collection<String> set, DBPKeywordType type) {
        for (String keyword : set) {
            DBPKeywordType oldType = this.allKeywords.get(keyword = keyword.toUpperCase(Locale.ENGLISH));
            if (oldType == DBPKeywordType.KEYWORD) continue;
            this.allKeywords.put(keyword, type);
        }
    }

    DBPKeywordType getKeywordType(String word) {
        return this.allKeywords.get(word.toUpperCase(Locale.ENGLISH));
    }

    String getCatalogSeparator() {
        return String.valueOf('.');
    }

    char getStructSeparator() {
        return '.';
    }

    String getScriptDelimiter() {
        return ";";
    }

    Pair<String, String> getMultiLineComments() {
        return this.multiLineComments;
    }

    String[] getSingleLineComments() {
        return DEFAULT_LINE_COMMENTS;
    }

    private void loadStandardKeywords() {
        HashSet<String> all = new HashSet<String>();
        Collections.addAll(all, SQLConstants.SQL2003_RESERVED_KEYWORDS);
        Collections.addAll(all, SQLConstants.SQL_EX_KEYWORDS);
        Collections.addAll(this.functions, SQLConstants.SQL2003_FUNCTIONS);
        for (String executeKeyword : this.getExecuteKeywords()) {
            this.addSQLKeyword(executeKeyword);
        }
        Collections.addAll(this.types, SQLConstants.DEFAULT_TYPES);
        this.addKeywords(all, DBPKeywordType.KEYWORD);
        this.addKeywords(this.types, DBPKeywordType.TYPE);
        this.addKeywords(this.functions, DBPKeywordType.FUNCTION);
    }
}

