/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.sql.dbeaver;

import com.github.autostyle.sql.dbeaver.FormatterToken;
import com.github.autostyle.sql.dbeaver.SQLDialect;
import com.github.autostyle.sql.dbeaver.TokenType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

class SQLTokensParser {
    private static final String[] twoCharacterSymbol = new String[]{"<>", "<=", ">=", "||", "()", "!=", ":=", ".*"};
    private static final SQLDialect sqlDialect = SQLDialect.INSTANCE;
    private final String[][] quoteStrings;
    private String fBefore = null;
    private int fPos;
    private char structSeparator;
    private String catalogSeparator;
    private Set<String> commands = new HashSet<String>();
    private String[] singleLineComments;
    private char[] singleLineCommentStart;

    SQLTokensParser() {
        this.structSeparator = sqlDialect.getStructSeparator();
        this.catalogSeparator = sqlDialect.getCatalogSeparator();
        this.quoteStrings = sqlDialect.getIdentifierQuoteStrings();
        this.singleLineComments = sqlDialect.getSingleLineComments();
        this.singleLineCommentStart = new char[this.singleLineComments.length];
        for (int i = 0; i < this.singleLineComments.length; ++i) {
            this.singleLineCommentStart[i] = this.singleLineComments[i].isEmpty() ? (char)'\u0000' : this.singleLineComments[i].charAt(0);
        }
    }

    private static boolean isSpace(char argChar) {
        return Character.isWhitespace(argChar);
    }

    private static boolean isLetter(char argChar) {
        return !SQLTokensParser.isSpace(argChar) && !SQLTokensParser.isDigit(argChar) && !SQLTokensParser.isSymbol(argChar);
    }

    private static boolean isDigit(char argChar) {
        return Character.isDigit(argChar);
    }

    private static boolean isSymbol(char argChar) {
        switch (argChar) {
            case '!': 
            case '\"': 
            case '%': 
            case '&': 
            case '\'': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '[': 
            case ']': 
            case '`': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private FormatterToken nextToken() {
        int start_pos = this.fPos;
        if (this.fPos >= this.fBefore.length()) {
            ++this.fPos;
            return new FormatterToken(TokenType.END, "", start_pos);
        }
        char fChar = this.fBefore.charAt(this.fPos);
        if (SQLTokensParser.isSpace(fChar)) {
            StringBuilder workString = new StringBuilder();
            do {
                workString.append(fChar);
                fChar = this.fBefore.charAt(this.fPos);
                if (!SQLTokensParser.isSpace(fChar)) {
                    return new FormatterToken(TokenType.SPACE, workString.toString(), start_pos);
                }
                ++this.fPos;
            } while (this.fPos < this.fBefore.length());
            return new FormatterToken(TokenType.SPACE, workString.toString(), start_pos);
        }
        if (fChar == ';') {
            ++this.fPos;
            return new FormatterToken(TokenType.SYMBOL, ";", start_pos);
        }
        if (SQLTokensParser.isDigit(fChar)) {
            StringBuilder s = new StringBuilder();
            while (SQLTokensParser.isDigit(fChar) || fChar == '.' || fChar == 'e' || fChar == 'E') {
                s.append(fChar);
                ++this.fPos;
                if (this.fPos >= this.fBefore.length()) break;
                fChar = this.fBefore.charAt(this.fPos);
            }
            return new FormatterToken(TokenType.VALUE, s.toString(), start_pos);
        }
        if (SQLTokensParser.contains(this.singleLineCommentStart, fChar)) {
            ++this.fPos;
            String commentString = null;
            for (String slc : this.singleLineComments) {
                if (this.fBefore.length() < start_pos + slc.length() || !slc.equals(this.fBefore.substring(start_pos, start_pos + slc.length()))) continue;
                commentString = slc;
                break;
            }
            if (commentString == null) {
                return new FormatterToken(TokenType.SYMBOL, String.valueOf(fChar), start_pos);
            }
            this.fPos += commentString.length() - 1;
            while (this.fPos < this.fBefore.length()) {
                ++this.fPos;
                if (this.fBefore.charAt(this.fPos - 1) != '\n') continue;
            }
            commentString = this.fBefore.substring(start_pos, this.fPos);
            return new FormatterToken(TokenType.COMMENT, commentString, start_pos);
        }
        if (SQLTokensParser.isLetter(fChar)) {
            String word;
            StringBuilder s = new StringBuilder();
            while (SQLTokensParser.isLetter(fChar) || SQLTokensParser.isDigit(fChar) || fChar == '*' || this.structSeparator == fChar || this.catalogSeparator.indexOf(fChar) != -1) {
                s.append(fChar);
                ++this.fPos;
                if (this.fPos >= this.fBefore.length()) break;
                fChar = this.fBefore.charAt(this.fPos);
            }
            if (this.commands.contains((word = s.toString()).toUpperCase(Locale.ENGLISH))) {
                s.setLength(0);
                while (this.fPos < this.fBefore.length() && (fChar = this.fBefore.charAt(this.fPos)) != '\n' && fChar != '\r') {
                    s.append(fChar);
                    ++this.fPos;
                }
                return new FormatterToken(TokenType.COMMAND, word + s.toString(), start_pos);
            }
            if (sqlDialect.getKeywordType(word) != null) {
                return new FormatterToken(TokenType.KEYWORD, word, start_pos);
            }
            return new FormatterToken(TokenType.NAME, word, start_pos);
        }
        if (fChar == '/') {
            char ch0;
            ++this.fPos;
            char ch2 = this.fBefore.charAt(this.fPos);
            if (ch2 != '*') {
                return new FormatterToken(TokenType.SYMBOL, "/", start_pos);
            }
            StringBuilder s = new StringBuilder("/*");
            ++this.fPos;
            do {
                ch0 = fChar;
                fChar = this.fBefore.charAt(this.fPos);
                s.append(fChar);
                ++this.fPos;
            } while (ch0 != '*' || fChar != '/');
            return new FormatterToken(TokenType.COMMENT, s.toString(), start_pos);
        }
        if (fChar == '\'' || this.isQuoteChar(fChar)) {
            ++this.fPos;
            char endQuoteChar = fChar;
            if (this.quoteStrings != null) {
                for (String[] quoteString : this.quoteStrings) {
                    if (((String)quoteString[0]).charAt(0) != endQuoteChar) continue;
                    endQuoteChar = ((String)quoteString[1]).charAt(0);
                    break;
                }
            }
            StringBuilder s = new StringBuilder();
            s.append(fChar);
            while (true) {
                char fNextChar;
                fChar = this.fBefore.charAt(this.fPos);
                s.append(fChar);
                ++this.fPos;
                char c = fNextChar = this.fPos >= this.fBefore.length() - 1 ? (char)'\u0000' : this.fBefore.charAt(this.fPos);
                if (fChar == endQuoteChar && fNextChar == endQuoteChar) {
                    s.append(fChar);
                    ++this.fPos;
                    continue;
                }
                if (fChar == endQuoteChar) break;
            }
            return new FormatterToken(TokenType.VALUE, s.toString(), start_pos);
        }
        if (SQLTokensParser.isSymbol(fChar)) {
            StringBuilder s = new StringBuilder(String.valueOf(fChar));
            ++this.fPos;
            if (this.fPos >= this.fBefore.length()) {
                return new FormatterToken(TokenType.SYMBOL, s.toString(), start_pos);
            }
            char ch2 = this.fBefore.charAt(this.fPos);
            for (String aTwoCharacterSymbol : twoCharacterSymbol) {
                if (aTwoCharacterSymbol.charAt(0) != fChar || aTwoCharacterSymbol.charAt(1) != ch2) continue;
                ++this.fPos;
                s.append(ch2);
                break;
            }
            return new FormatterToken(TokenType.SYMBOL, s.toString(), start_pos);
        }
        ++this.fPos;
        return new FormatterToken(TokenType.UNKNOWN, String.valueOf(fChar), start_pos);
    }

    private boolean isQuoteChar(char fChar) {
        if (this.quoteStrings != null) {
            for (String[] quoteString : this.quoteStrings) {
                if (quoteString[0].charAt(0) != fChar) continue;
                return true;
            }
        }
        return false;
    }

    List<FormatterToken> parse(String argSql) {
        FormatterToken token;
        this.fPos = 0;
        this.fBefore = argSql;
        ArrayList<FormatterToken> list = new ArrayList<FormatterToken>();
        while ((token = this.nextToken()).getType() != TokenType.END) {
            list.add(token);
        }
        return list;
    }

    private static boolean contains(char[] array, char value) {
        if (array == null || array.length == 0) {
            return false;
        }
        for (char aChar : array) {
            if (aChar != value) continue;
            return true;
        }
        return false;
    }
}

