/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.Formatter;
import com.github.autostyle.PaddedCell;
import com.github.autostyle.PaddedCellBulk;
import com.github.autostyle.gradle.AutostyleTask;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fJ\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/github/autostyle/gradle/PaddedCellGradle;", "", "()V", "URL", "", "check", "", "task", "Lcom/github/autostyle/gradle/AutostyleTask;", "formatter", "Lcom/github/autostyle/Formatter;", "problemFiles", "", "Ljava/io/File;", "diagnoseDir", "youShouldTurnOnPaddedCell", "Lorg/gradle/api/GradleException;", "cell", "Lcom/github/autostyle/PaddedCell;", "autostyle-plugin-gradle"})
public final class PaddedCellGradle {
    private static final String URL = "https://github.com/autostyle/autostyle/blob/master/PADDEDCELL.md";
    public static final PaddedCellGradle INSTANCE;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final GradleException youShouldTurnOnPaddedCell(@NotNull AutostyleTask task, @NotNull PaddedCell cell) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)cell, (String)"cell");
        Project project = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
        Path rootPath = project.getRootDir().toPath();
        File diagnoseDir = this.diagnoseDir(task);
        diagnoseDir.mkdirs();
        File file = cell.file();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"cell.file()");
        String name = FilesKt.getNameWithoutExtension((File)file);
        File file2 = cell.file();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"cell.file()");
        String extension = FilesKt.getExtension((File)file2);
        boolean bl = false;
        List list = cell.steps();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cell.steps()");
        for (String step : (Iterable)list) {
            void index;
            File file3 = new File(diagnoseDir, name + '.' + (int)(index + true) + '.' + extension);
            String string = step;
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"step");
            FilesKt.writeText$default((File)file3, (String)string, null, (int)2, null);
            ++index;
        }
        return new GradleException(StringsKt.trimIndent((String)("\n            You have a misbehaving rule which can't make up its mind.\n            This means that autostyleCheck will fail even after autostyleApply has run.\n\n            The file in question is " + rootPath.relativize(cell.file().toPath()) + "\n            Formatting " + cell.userMessage() + "\n            You can find intermediate results in " + rootPath.relativize(diagnoseDir.toPath()) + "\n\n            This is a bug in a formatting rule, not Autostyle itself, but Autostyle can\n            work around this bug and generate helpful bug reports for the broken rule\n            if you add 'paddedCell()' to your build.gradle as such:\n\n                autostyle {\n                    format 'someFormat', {\n                        ...\n                        paddedCell()\n                    }\n                }\n\n            For details see https://github.com/autostyle/autostyle/blob/master/PADDEDCELL.md\n            ")));
    }

    private final File diagnoseDir(AutostyleTask task) {
        Project project = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
        return new File(project.getBuildDir(), "autostyle-diagnose-" + task.formatName());
    }

    public final void check(@NotNull AutostyleTask task, @NotNull Formatter formatter, @NotNull List<? extends File> problemFiles) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)task), (String)"task");
        Intrinsics.checkParameterIsNotNull((Object)formatter, (String)"formatter");
        Intrinsics.checkParameterIsNotNull(problemFiles, (String)"problemFiles");
        if (problemFiles.isEmpty()) {
            task.getLogger().info(StringsKt.trimIndent((String)("\n                " + task.getName() + " is in paddedCell() mode, but it doesn't need to be.\n                If you remove that option, Autostyle will run ~2x faster.\n                For details see https://github.com/autostyle/autostyle/blob/master/PADDEDCELL.md\n                ")));
        }
        File diagnoseDir = this.diagnoseDir(task);
        Project project = task.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"task.project");
        File file = project.getRootDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"task.project.rootDir");
        File rootDir = file;
        List list = PaddedCellBulk.check((File)rootDir, (File)diagnoseDir, (Formatter)formatter, problemFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"PaddedCellBulk.check(roo\u2026 formatter, problemFiles)");
        List stillFailing = list;
        Collection collection = stillFailing;
        boolean bl = false;
        if (!collection.isEmpty()) {
            throw (Throwable)task.formatViolationsFor(formatter, problemFiles);
        }
    }

    private PaddedCellGradle() {
    }

    static {
        PaddedCellGradle paddedCellGradle;
        INSTANCE = paddedCellGradle = new PaddedCellGradle();
    }
}

