/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.Formatter;
import com.github.autostyle.PaddedCell;
import com.github.autostyle.PaddedCellBulk;
import com.github.autostyle.gradle.AutostyleTask;
import com.github.autostyle.gradle.PaddedCellGradle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/github/autostyle/gradle/AutostyleCheckTask;", "Lcom/github/autostyle/gradle/AutostyleTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "check", "", "Ljava/io/File;", "formatter", "Lcom/github/autostyle/Formatter;", "filesToCheck", "performAction", "", "inputChanges", "Lorg/gradle/work/InputChanges;", "autostyle-plugin-gradle"})
public class AutostyleCheckTask
extends AutostyleTask {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void performAction(@NotNull InputChanges inputChanges) {
        Intrinsics.checkParameterIsNotNull((Object)inputChanges, (String)"inputChanges");
        boolean bl = false;
        Set filesToCheck = new LinkedHashSet();
        Iterable iterable = inputChanges.getFileChanges((FileCollection)this.getSourceFiles());
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"inputChanges.getFileChanges(sourceFiles)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileChange it = (FileChange)element$iv;
            boolean bl2 = false;
            FileChange fileChange = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChange, (String)"it");
            if (fileChange.getChangeType() == ChangeType.REMOVED || it.getFileType() != FileType.FILE) continue;
            File file = it.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it.file");
            filesToCheck.add(file);
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.getFormatter();
        boolean bl3 = false;
        Object object = null;
        try {
            Formatter it = (Formatter)autoCloseable;
            boolean bl4 = false;
            Collection<File> collection = this.check(it, filesToCheck);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<File> check(Formatter formatter, Collection<? extends File> filesToCheck) {
        void $this$filterNotTo$iv$iv;
        Iterable $this$filterNot$iv = filesToCheck;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            File it = (File)element$iv$iv;
            boolean bl = false;
            this.getLogger().debug("Checking format of {}", (Object)it);
            if (formatter.isClean(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List problemFiles = (List)destination$iv$iv;
        Object object = this.getPaddedCell().get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"paddedCell.get()");
        if (((Boolean)object).booleanValue()) {
            PaddedCellGradle.INSTANCE.check(this, formatter, problemFiles);
        } else {
            $this$filterNot$iv = problemFiles;
            boolean bl = false;
            if (!$this$filterNot$iv.isEmpty()) {
                PaddedCell cell = PaddedCellBulk.anyMisbehave((Formatter)formatter, (List)problemFiles);
                if (cell != null) {
                    throw (Throwable)PaddedCellGradle.INSTANCE.youShouldTurnOnPaddedCell(this, cell);
                }
                throw (Throwable)this.formatViolationsFor(formatter, problemFiles);
            }
        }
        return problemFiles;
    }

    @Inject
    public AutostyleCheckTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        super(objects);
        String string = System.getenv("JITPACK");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            if (Boolean.parseBoolean(string2)) {
                this.setEnabled(false);
            }
        }
    }
}

