/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.Formatter;
import com.github.autostyle.FormatterStep;
import com.github.autostyle.LineEnding;
import com.github.autostyle.extra.integration.DiffMessageFormatter;
import com.github.autostyle.gradle.ext.GradleExtensionsKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.ExtraPropertiesExtensionsKt;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u0007J\u001c\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%J\u0010\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020)H'J\u001b\u0010*\u001a\u0004\u0018\u00010+*\u00020,2\u0006\u0010-\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u0004\u0018\u00010\u0007*\u00020,2\u0006\u0010-\u001a\u00020\u0007H\u0002R!\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f8G\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR!\u0010\u000f\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00100\u00100\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR!\u0010\u0012\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00130\u00130\u00068G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\nR\u0013\u0010\u0015\u001a\u00020\u00168G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00060"}, d2={"Lcom/github/autostyle/gradle/AutostyleTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "encoding", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getEncoding", "()Lorg/gradle/api/provider/Property;", "formatter", "Lcom/github/autostyle/Formatter;", "getFormatter", "()Lcom/github/autostyle/Formatter;", "lineEndingsPolicy", "Lcom/github/autostyle/LineEnding$Policy;", "getLineEndingsPolicy", "paddedCell", "", "getPaddedCell", "sourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "steps", "Lorg/gradle/api/provider/ListProperty;", "Lcom/github/autostyle/FormatterStep;", "getSteps", "()Lorg/gradle/api/provider/ListProperty;", "addStep", "", "step", "formatName", "formatViolationsFor", "Lorg/gradle/api/GradleException;", "problemFiles", "", "Ljava/io/File;", "performAction", "inputChanges", "Lorg/gradle/work/InputChanges;", "intProperty", "", "Lorg/gradle/api/Project;", "name", "(Lorg/gradle/api/Project;Ljava/lang/String;)Ljava/lang/Integer;", "stringProperty", "autostyle-plugin-gradle"})
public abstract class AutostyleTask
extends DefaultTask {
    @NotNull
    private final Property<String> encoding;
    @NotNull
    private final Property<LineEnding.Policy> lineEndingsPolicy;
    @NotNull
    private final Property<Boolean> paddedCell;
    @NotNull
    private final ListProperty<FormatterStep> steps;
    @NotNull
    private final ConfigurableFileCollection sourceFiles;

    @Input
    @NotNull
    public final Property<String> getEncoding() {
        return this.encoding;
    }

    @Input
    @NotNull
    public final Property<LineEnding.Policy> getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    @Input
    @NotNull
    public final Property<Boolean> getPaddedCell() {
        return this.paddedCell;
    }

    @Input
    @NotNull
    public final ListProperty<FormatterStep> getSteps() {
        return this.steps;
    }

    @InputFiles
    @SkipWhenEmpty
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    public final void addStep(@NotNull FormatterStep step) {
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        this.steps.add((Object)step);
    }

    @TaskAction
    public abstract void performAction(@NotNull InputChanges var1);

    @NotNull
    public final String formatName() {
        String string;
        String string2 = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"name");
        String name = string2;
        if (StringsKt.startsWith$default((String)name, (String)"autostyle", (boolean)false, (int)2, null)) {
            String string3 = name;
            int n = "autostyle".length();
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            string3 = string5;
            Locale locale = Locale.ROOT;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ROOT");
            Locale locale2 = locale;
            bl = false;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string7 = string6.toLowerCase(locale2);
            string = string7;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).toLowerCase(locale)");
        } else {
            string = name;
        }
        return string;
    }

    @Input
    @NotNull
    public final Formatter getFormatter() {
        Formatter.Builder builder = Formatter.builder().lineEndingsPolicy((LineEnding.Policy)this.lineEndingsPolicy.get()).encoding(Charset.forName((String)this.encoding.get()));
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Formatter formatter = builder.rootDir(project.getRootDir().toPath()).steps((List)this.steps.get()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)formatter, (String)"Formatter.builder()\n    \u2026t())\n            .build()");
        return formatter;
    }

    private final String stringProperty(@NotNull Project $this$stringProperty, String name) {
        String string;
        boolean bl = ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)$this$stringProperty)).has(name);
        if (bl) {
            Object object = ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)$this$stringProperty)).get(name);
            if (!(object instanceof String)) {
                object = null;
            }
            string = (String)object;
        } else {
            string = null;
        }
        return string;
    }

    private final Integer intProperty(@NotNull Project $this$intProperty, String name) {
        Integer n;
        String string = this.stringProperty($this$intProperty, name);
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            n = Integer.parseInt(string2);
        } else {
            n = null;
        }
        return n;
    }

    @NotNull
    public final GradleException formatViolationsFor(@NotNull Formatter formatter, @NotNull List<? extends File> problemFiles) {
        Intrinsics.checkParameterIsNotNull((Object)formatter, (String)"formatter");
        Intrinsics.checkParameterIsNotNull(problemFiles, (String)"problemFiles");
        StringBuilder sb = new StringBuilder();
        sb.append("The following files have format violations:\n");
        DiffMessageFormatter diffMessageFormatter = new DiffMessageFormatter(formatter, sb);
        boolean bl = false;
        boolean bl2 = false;
        DiffMessageFormatter $this$apply = diffMessageFormatter;
        boolean bl3 = false;
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Integer n = this.intProperty(project, "maxCheckMessageLines");
        $this$apply.setMaxCheckMessageLines(n != null ? n.intValue() : $this$apply.getMaxCheckMessageLines());
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        Integer n2 = this.intProperty(project2, "maxFilesToList");
        $this$apply.setMaxFilesToList(n2 != null ? n2.intValue() : $this$apply.getMaxFilesToList());
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        Integer n3 = this.intProperty(project3, "minLinesPerFile");
        $this$apply.setMinLinesPerFile(n3 != null ? n3.intValue() : $this$apply.getMinLinesPerFile());
        List list = CollectionsKt.sorted((Iterable)problemFiles);
        Object object = this.paddedCell.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"paddedCell.get()");
        $this$apply.diff(list, ((Boolean)object).booleanValue());
        sb.append("Run './gradlew autostyleApply' to fix the violations.");
        return new GradleException(sb.toString());
    }

    /*
     * WARNING - void declaration
     */
    @Inject
    public AutostyleTask(@NotNull ObjectFactory objects) {
        void $this$listProperty$iv;
        ObjectFactory $this$property$iv;
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
        ObjectFactory objectFactory = objects;
        AutostyleTask autostyleTask = this;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"property(T::class.java)");
        Property property2 = property;
        autostyleTask.encoding = GradleExtensionsKt.conv(property2, "UTF-8");
        $this$property$iv = objects;
        autostyleTask = this;
        $i$f$property = false;
        Property property3 = $this$property$iv.property(LineEnding.Policy.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property3, (String)"property(T::class.java)");
        property2 = property3;
        LineEnding.Policy policy = LineEnding.UNIX.createPolicy();
        Intrinsics.checkExpressionValueIsNotNull((Object)policy, (String)"LineEnding.UNIX.createPolicy()");
        autostyleTask.lineEndingsPolicy = GradleExtensionsKt.conv(property2, policy);
        $this$property$iv = objects;
        autostyleTask = this;
        $i$f$property = false;
        Property property4 = $this$property$iv.property(Boolean.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)property4, (String)"property(T::class.java)");
        property2 = property4;
        autostyleTask.paddedCell = GradleExtensionsKt.conv(property2, false);
        $this$property$iv = objects;
        autostyleTask = this;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(FormatterStep.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)listProperty, (String)"listProperty(T::class.java)");
        autostyleTask.steps = property2 = listProperty;
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files()");
        this.sourceFiles = configurableFileCollection;
    }
}

