/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.ConvergenceAnalyzer;
import com.github.autostyle.ConvergenceResult;
import com.github.autostyle.Formatter;
import com.github.autostyle.FormatterStep;
import com.github.autostyle.LineEnding;
import com.github.autostyle.gradle.ext.GradleExtensionsKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b'\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 J\u001e\u0010&\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0007J.\u0010,\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00H\u0002R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00140\u00140\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0016\u0010\u0016\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lcom/github/autostyle/gradle/AutostyleTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "divergingDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getDivergingDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "encoding", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getEncoding", "()Lorg/gradle/api/provider/Property;", "formatter", "Lcom/github/autostyle/Formatter;", "getFormatter", "()Lcom/github/autostyle/Formatter;", "lineEndingsPolicy", "Lcom/github/autostyle/LineEnding$Policy;", "getLineEndingsPolicy", "outputDirectory", "getOutputDirectory", "projectDirectory", "Ljava/io/File;", "sourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "steps", "Lorg/gradle/api/provider/ListProperty;", "Lcom/github/autostyle/FormatterStep;", "getSteps", "()Lorg/gradle/api/provider/ListProperty;", "addStep", "", "step", "formatFiles", "filesToCheck", "", "run", "inputChanges", "Lorg/gradle/work/InputChanges;", "storeCycle", "divergingDir", "relativeFile", "cycle", "", "autostyle-plugin-gradle"})
public abstract class AutostyleTask
extends DefaultTask {
    @NotNull
    private final Property<String> encoding;
    @NotNull
    private final Property<LineEnding.Policy> lineEndingsPolicy;
    @NotNull
    private final ListProperty<FormatterStep> steps;
    @NotNull
    private final ConfigurableFileCollection sourceFiles;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty divergingDirectory;
    private final File projectDirectory;

    @Input
    @NotNull
    public final Property<String> getEncoding() {
        return this.encoding;
    }

    @Input
    @NotNull
    public final Property<LineEnding.Policy> getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    @Input
    @NotNull
    public final ListProperty<FormatterStep> getSteps() {
        return this.steps;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    public final void addStep(@NotNull FormatterStep step) {
        Intrinsics.checkParameterIsNotNull((Object)step, (String)"step");
        this.steps.add((Object)step);
    }

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    public final DirectoryProperty getDivergingDirectory() {
        return this.divergingDirectory;
    }

    @Internal
    @NotNull
    public final Formatter getFormatter() {
        Formatter.Builder builder = Formatter.builder().lineEndingsPolicy((LineEnding.Policy)this.lineEndingsPolicy.get()).encoding(Charset.forName((String)this.encoding.get()));
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        Formatter formatter = builder.rootDir(project.getRootDir().toPath()).steps((List)this.steps.get()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)formatter, (String)"Formatter.builder()\n    \u2026\n                .build()");
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run(@NotNull InputChanges inputChanges) {
        Intrinsics.checkParameterIsNotNull((Object)inputChanges, (String)"inputChanges");
        Object object = this.outputDirectory.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDirectory.get().asFile");
        File outputDir = file;
        if (!inputChanges.isIncremental()) {
            this.getProject().delete(new Object[]{outputDir});
        }
        this.getProject().mkdir((Object)outputDir);
        Object object2 = this.divergingDirectory.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"divergingDirectory.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"divergingDirectory.get().asFile");
        File divergingDir = file2;
        this.getProject().delete(new Object[]{divergingDir});
        this.getProject().mkdir((Object)divergingDir);
        boolean bl = false;
        List filesToCheck = new ArrayList();
        Iterable iterable = inputChanges.getFileChanges((FileCollection)this.sourceFiles);
        Intrinsics.checkExpressionValueIsNotNull((Object)iterable, (String)"inputChanges.getFileChanges(sourceFiles)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileChange it = (FileChange)element$iv;
            boolean bl2 = false;
            FileChange fileChange = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileChange, (String)"it");
            if (fileChange.getChangeType() == ChangeType.REMOVED) {
                File file3 = it.getFile();
                Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"it.file");
                File outFile = FilesKt.resolve((File)outputDir, (File)FilesKt.relativeTo((File)file3, (File)this.projectDirectory));
                this.getProject().delete(new Object[]{outFile});
            }
            if (it.getChangeType() == ChangeType.REMOVED || it.getFileType() != FileType.FILE) continue;
            File file4 = it.getFile();
            Intrinsics.checkExpressionValueIsNotNull((Object)file4, (String)"it.file");
            filesToCheck.add(file4);
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.getFormatter();
        boolean bl3 = false;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            Formatter it = (Formatter)autoCloseable;
            boolean bl5 = false;
            this.formatFiles(it, filesToCheck);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void formatFiles(Formatter formatter, Collection<? extends File> filesToCheck) {
        Object object = this.outputDirectory.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"outputDirectory.get()");
        File file = ((Directory)object).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"outputDirectory.get().asFile");
        File outputDir = file;
        Object object2 = this.divergingDirectory.get();
        Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"divergingDirectory.get()");
        File file2 = ((Directory)object2).getAsFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"divergingDirectory.get().asFile");
        File divergingDir = file2;
        ConvergenceAnalyzer convergenceAnalyzer = new ConvergenceAnalyzer(formatter, 0, 2, null);
        boolean bl = false;
        List diverges = new ArrayList();
        boolean bl2 = false;
        List cycles = new ArrayList();
        for (File file3 : filesToCheck) {
            boolean bl3;
            String string;
            Collection collection;
            this.getLogger().debug("Applying format to {}", (Object)file3);
            ConvergenceResult result = convergenceAnalyzer.analyze(file3);
            File relativeFile = FilesKt.relativeTo((File)file3, (File)this.projectDirectory);
            File outFile = FilesKt.resolve((File)outputDir, (File)relativeFile);
            outFile.getParentFile().mkdirs();
            ConvergenceResult convergenceResult = result;
            if (convergenceResult instanceof ConvergenceResult.Clean) {
                this.getProject().delete(new Object[]{outFile});
                continue;
            }
            if (convergenceResult instanceof ConvergenceResult.Convergence) {
                String string2 = result.getFormatted();
                Charset charset = formatter.getEncoding();
                Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"formatter.encoding");
                FilesKt.writeText((File)outFile, (String)string2, (Charset)charset);
                continue;
            }
            if (convergenceResult instanceof ConvergenceResult.Cycle) {
                this.storeCycle(formatter, divergingDir, relativeFile, ((ConvergenceResult.Cycle)result).getCycle());
                collection = cycles;
                string = relativeFile.toString();
                bl3 = false;
                collection.add(string);
                continue;
            }
            if (!(convergenceResult instanceof ConvergenceResult.Divergence)) continue;
            this.storeCycle(formatter, divergingDir, relativeFile, ((ConvergenceResult.Divergence)result).getCycle());
            collection = diverges;
            string = relativeFile.toString();
            bl3 = false;
            collection.add(string);
        }
        if (diverges.isEmpty() && cycles.isEmpty()) {
            return;
        }
        throw (Throwable)new GradleException(StringsKt.removeSuffix((String)("Formatting " + StringsKt.removeSuffix((String)CollectionsKt.joinToString$default((Iterable)cycles, null, (CharSequence)"cycles for ", (CharSequence)", ", (int)0, null, null, (int)57, null), (CharSequence)"cycles for , ") + StringsKt.removeSuffix((String)CollectionsKt.joinToString$default((Iterable)diverges, null, (CharSequence)"diverges for ", null, (int)0, null, null, (int)61, null), (CharSequence)"diverges for ")), (CharSequence)", "));
    }

    /*
     * WARNING - void declaration
     */
    private final void storeCycle(Formatter formatter, File divergingDir, File relativeFile, List<String> cycle) {
        File outFile = FilesKt.resolve((File)divergingDir, (File)relativeFile);
        this.getProject().mkdir((Object)outFile.getParentFile());
        String outPath = outFile.getAbsolutePath();
        boolean bl = false;
        for (String value : (Iterable)cycle) {
            void index;
            File file = new File(outPath + "." + StringsKt.padStart((String)String.valueOf((int)index), (int)2, (char)'0'));
            Charset charset = formatter.getEncoding();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"formatter.encoding");
            FilesKt.writeText((File)file, (String)value, (Charset)charset);
            ++index;
        }
    }

    @Inject
    public AutostyleTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkParameterIsNotNull((Object)objects, (String)"objects");
        String string = System.getenv("JITPACK");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            boolean bl2 = false;
            if (Boolean.parseBoolean(string3)) {
                this.setEnabled(false);
            }
        }
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.encoding = GradleExtensionsKt.conv(property, "UTF-8");
        $this$property$iv = objects;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(LineEnding.Policy.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        LineEnding.Policy policy = LineEnding.UNIX.createPolicy();
        Intrinsics.checkExpressionValueIsNotNull((Object)policy, (String)"LineEnding.UNIX.createPolicy()");
        this.lineEndingsPolicy = GradleExtensionsKt.conv(property2, policy);
        ObjectFactory $this$listProperty$iv = objects;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(FormatterStep.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.steps = listProperty;
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)configurableFileCollection, (String)"project.files()");
        this.sourceFiles = configurableFileCollection;
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Project project = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
        DirectoryProperty directoryProperty2 = directoryProperty.convention(projectLayout.getBuildDirectory().dir("autostyle/" + this.getName() + "/formatted"));
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty2, (String)"objects.directoryPropert\u2026ostyle/$name/formatted\"))");
        this.outputDirectory = directoryProperty2;
        DirectoryProperty directoryProperty3 = objects.directoryProperty();
        Project project2 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        ProjectLayout projectLayout2 = project2.getLayout();
        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout2, (String)"project.layout");
        DirectoryProperty directoryProperty4 = directoryProperty3.convention(projectLayout2.getBuildDirectory().dir("autostyle/" + this.getName() + "/diverging"));
        Intrinsics.checkExpressionValueIsNotNull((Object)directoryProperty4, (String)"objects.directoryPropert\u2026ostyle/$name/diverging\"))");
        this.divergingDirectory = directoryProperty4;
        Project project3 = this.getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
        File file = project3.getProjectDir();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.projectDir");
        this.projectDirectory = file;
    }
}

