/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0007R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/github/autostyle/gradle/AutostyleApplyTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "inputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "run", "", "autostyle-plugin-gradle"})
public class AutostyleApplyTask
extends DefaultTask {
    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final DirectoryProperty inputDirectory;

    @Inject
    public AutostyleApplyTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.inputDirectory = directoryProperty;
    }

    @NotNull
    public final DirectoryProperty getInputDirectory() {
        return this.inputDirectory;
    }

    @TaskAction
    public final void run() {
        File file = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        File projectDir = file;
        Ref.BooleanRef hasUpdates = new Ref.BooleanRef();
        this.getProject().fileTree((Object)this.inputDirectory).visit(new Action(hasUpdates, projectDir){
            final /* synthetic */ Ref.BooleanRef $hasUpdates;
            final /* synthetic */ File $projectDir;
            {
                this.$hasUpdates = $hasUpdates;
                this.$projectDir = $projectDir;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void execute(@NotNull FileVisitDetails $this$visit) {
                Intrinsics.checkNotNullParameter((Object)$this$visit, (String)"$this$visit");
                if (!$this$visit.isDirectory()) {
                    this.$hasUpdates.element = true;
                    StringBuilder stringBuilder = new StringBuilder().append("Apply: ").append($this$visit.getPath()).append(" => ");
                    String string = $this$visit.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                    System.out.println((Object)stringBuilder.append(FilesKt.resolve((File)this.$projectDir, (String)string)).toString());
                    String string2 = $this$visit.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"path");
                    Object object = FilesKt.resolve((File)this.$projectDir, (String)string2);
                    object = new FileOutputStream((File)object);
                    Throwable throwable = null;
                    try {
                        FileOutputStream it = (FileOutputStream)object;
                        boolean bl = false;
                        $this$visit.copyTo((OutputStream)it);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    }
                }
            }
        });
        this.setDidWork(hasUpdates.element);
    }
}

