/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.extra.integration.DiffMessageFormatter;
import com.github.autostyle.gradle.ext.GradleExtensionsKt;
import java.io.File;
import java.nio.charset.Charset;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.kotlin.dsl.ExtraPropertiesExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u001b\u0010\u0018\u001a\u0004\u0018\u00010\u0010*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u0007*\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R$\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR$\u0010\u000f\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00100\u00100\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\nR$\u0010\u0012\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00100\u00100\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR$\u0010\u0014\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00100\u00100\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\n\u00a8\u0006\u001d"}, d2={"Lcom/github/autostyle/gradle/AutostyleCheckTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "encoding", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getEncoding", "()Lorg/gradle/api/provider/Property;", "inputDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getInputDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "maxCheckMessageLines", "", "getMaxCheckMessageLines", "maxFilesToList", "getMaxFilesToList", "minLinesPerFile", "getMinLinesPerFile", "run", "", "intProperty", "Lorg/gradle/api/Project;", "name", "(Lorg/gradle/api/Project;Ljava/lang/String;)Ljava/lang/Integer;", "stringProperty", "autostyle-plugin-gradle"})
@SourceDebugExtension(value={"SMAP\nAutostyleCheckTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutostyleCheckTask.kt\ncom/github/autostyle/gradle/AutostyleCheckTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n*L\n1#1,97:1\n59#2:98\n59#2:99\n59#2:100\n59#2:101\n*S KotlinDebug\n*F\n+ 1 AutostyleCheckTask.kt\ncom/github/autostyle/gradle/AutostyleCheckTask\n*L\n40#1:98\n43#1:99\n48#1:100\n53#1:101\n*E\n"})
public class AutostyleCheckTask
extends DefaultTask {
    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    private final DirectoryProperty inputDirectory;
    @Input
    @NotNull
    private final Property<String> encoding;
    @Console
    @NotNull
    private final Property<Integer> maxCheckMessageLines;
    @Console
    @NotNull
    private final Property<Integer> maxFilesToList;
    @Console
    @NotNull
    private final Property<Integer> minLinesPerFile;

    @Inject
    public AutostyleCheckTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        DirectoryProperty directoryProperty = objects.directoryProperty();
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryProperty()");
        this.inputDirectory = directoryProperty;
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.encoding = GradleExtensionsKt.conv(property, "UTF-8");
        ObjectFactory $this$property$iv2 = objects;
        boolean $i$f$property2 = false;
        Property property2 = $this$property$iv2.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Integer n = this.intProperty(project, "maxCheckMessageLines");
        Property property3 = property2.convention((Object)(n != null ? n : 50));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"objects.property<Int>().\u2026essageLines\") ?: 50\n    )");
        this.maxCheckMessageLines = property3;
        $this$property$iv2 = objects;
        $i$f$property2 = false;
        Property property4 = $this$property$iv2.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property4, (String)"property(T::class.java)");
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Integer n2 = this.intProperty(project2, "maxFilesToList");
        property3 = property4.convention((Object)(n2 != null ? n2 : 10));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"objects.property<Int>().\u2026FilesToList\") ?: 10\n    )");
        this.maxFilesToList = property3;
        $this$property$iv2 = objects;
        $i$f$property2 = false;
        Property property5 = $this$property$iv2.property(Integer.class);
        Intrinsics.checkNotNullExpressionValue((Object)property5, (String)"property(T::class.java)");
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        Integer n3 = this.intProperty(project3, "minLinesPerFile");
        property3 = property5.convention((Object)(n3 != null ? n3 : 4));
        Intrinsics.checkNotNullExpressionValue((Object)property3, (String)"objects.property<Int>().\u2026LinesPerFile\") ?: 4\n    )");
        this.minLinesPerFile = property3;
    }

    @NotNull
    public final DirectoryProperty getInputDirectory() {
        return this.inputDirectory;
    }

    @NotNull
    public final Property<String> getEncoding() {
        return this.encoding;
    }

    @NotNull
    public final Property<Integer> getMaxCheckMessageLines() {
        return this.maxCheckMessageLines;
    }

    @NotNull
    public final Property<Integer> getMaxFilesToList() {
        return this.maxFilesToList;
    }

    @NotNull
    public final Property<Integer> getMinLinesPerFile() {
        return this.minLinesPerFile;
    }

    private final String stringProperty(Project $this$stringProperty, String name) {
        Object object;
        return ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)$this$stringProperty)).has(name) ? ((object = ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)$this$stringProperty)).get(name)) instanceof String ? (String)object : null) : null;
    }

    private final Integer intProperty(Project $this$intProperty, String name) {
        String string = this.stringProperty($this$intProperty, name);
        return string != null ? Integer.valueOf(Integer.parseInt(string)) : null;
    }

    @TaskAction
    public final void run() {
        StringBuilder sb = new StringBuilder();
        sb.append("The following files have format violations:\n");
        File file = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        Object object = this.maxCheckMessageLines.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"maxCheckMessageLines.get()");
        int n = ((Number)object).intValue();
        Object object2 = this.maxFilesToList.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"maxFilesToList.get()");
        int n2 = ((Number)object2).intValue();
        Object object3 = this.minLinesPerFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"minLinesPerFile.get()");
        DiffMessageFormatter writer = new DiffMessageFormatter(file, sb, n, n2, ((Number)object3).intValue());
        File file2 = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.projectDir");
        File projectDir = file2;
        Charset encoding2 = Charset.forName((String)this.encoding.get());
        this.getProject().fileTree((Object)this.inputDirectory).visit(new Action(writer, projectDir, encoding2){
            final /* synthetic */ DiffMessageFormatter $writer;
            final /* synthetic */ File $projectDir;
            final /* synthetic */ Charset $encoding;
            {
                this.$writer = $writer;
                this.$projectDir = $projectDir;
                this.$encoding = $encoding;
            }

            public final void execute(@NotNull FileVisitDetails $this$visit) {
                Intrinsics.checkNotNullParameter((Object)$this$visit, (String)"$this$visit");
                if (!$this$visit.isDirectory()) {
                    String string = $this$visit.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"path");
                    File file = FilesKt.resolve((File)this.$projectDir, (String)string);
                    File file2 = $this$visit.getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                    Charset charset = this.$encoding;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"encoding");
                    this.$writer.addDiff(file, file2, charset);
                }
            }
        });
        if (writer.finishWithoutErrors()) {
            this.setDidWork(false);
            return;
        }
        this.setDidWork(true);
        sb.append("You might want to adjust");
        StringBuilder stringBuilder = sb.append(" -PmaxCheckMessageLines=");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"sb.append(\" -PmaxCheckMessageLines=\")");
        StringBuilder stringBuilder2 = stringBuilder;
        Object object4 = this.maxCheckMessageLines.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"maxCheckMessageLines.get()");
        int n3 = ((Number)object4).intValue();
        StringBuilder stringBuilder3 = stringBuilder2.append(n3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder4 = sb.append(" -PmaxFilesToList=");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"sb.append(\" -PmaxFilesToList=\")");
        stringBuilder2 = stringBuilder4;
        Object object5 = this.maxFilesToList.get();
        Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"maxFilesToList.get()");
        n3 = ((Number)object5).intValue();
        StringBuilder stringBuilder5 = stringBuilder2.append(n3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder5.append('\n'), (String)"append(...)");
        StringBuilder stringBuilder6 = sb.append(" -PminLinesPerFile=");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder6, (String)"sb.append(\" -PminLinesPerFile=\")");
        stringBuilder2 = stringBuilder6;
        Object object6 = this.minLinesPerFile.get();
        Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"minLinesPerFile.get()");
        n3 = ((Number)object6).intValue();
        StringBuilder stringBuilder7 = stringBuilder2.append(n3);
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder7.append('\n'), (String)"append(...)");
        sb.append(" to see more violations\n");
        sb.append("Run './gradlew autostyleApply' to fix the violations.");
        throw new GradleException(sb.toString());
    }
}

