/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.gradle.AutostyleApplyTask;
import com.github.autostyle.gradle.AutostyleCheckTask;
import com.github.autostyle.gradle.AutostyleExtension;
import com.github.autostyle.gradle.AutostylePlugin;
import java.io.File;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.plugins.BasePlugin;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.tasks.TaskCollection;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.kotlin.dsl.ExtraPropertiesExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\f\u0010\u0007\u001a\u00020\u0005*\u00020\u0002H\u0002J\f\u0010\b\u001a\u00020\u0005*\u00020\u0002H\u0002\u00a8\u0006\n"}, d2={"Lcom/github/autostyle/gradle/AutostylePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "configurePlugin", "installProjectPathsExtra", "Companion", "autostyle-plugin-gradle"})
public final class AutostylePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TASK_GROUP = "Verification";
    @NotNull
    private static final String CHECK_DESCRIPTION = "Checks that sourcecode satisfies formatting steps.";
    @NotNull
    private static final String APPLY_DESCRIPTION = "Applies code formatting steps to sourcecode in-place.";
    @NotNull
    private static final String FILES_PROPERTY = "autostyleFiles";
    @NotNull
    public static final String PROJECT_DIR_MAP = "_autostyleProjectDirMap_";

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.configurePlugin(project);
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        this.installProjectPathsExtra(project2);
    }

    private final void installProjectPathsExtra(Project $this$installProjectPathsExtra) {
        if (ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)$this$installProjectPathsExtra)).has(PROJECT_DIR_MAP)) {
            return;
        }
        ExtraPropertiesExtensionsKt.getExtra((ExtensionAware)((ExtensionAware)$this$installProjectPathsExtra)).set(PROJECT_DIR_MAP, (Object)LazyKt.lazy((Function0)((Function0)new Function0<TreeSet<String>>($this$installProjectPathsExtra){
            final /* synthetic */ Project $this_installProjectPathsExtra;
            {
                this.$this_installProjectPathsExtra = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final TreeSet<String> invoke() {
                void var2_2;
                void $this$mapTo$iv;
                Set set = this.$this_installProjectPathsExtra.getAllprojects();
                Intrinsics.checkNotNullExpressionValue((Object)set, (String)"allprojects");
                Sequence sequence = SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.plus((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)set), (Function1)installProjectPathsExtra.1.INSTANCE), (Object)new File(this.$this_installProjectPathsExtra.getRootDir(), "buildSrc")), (Object)new File(this.$this_installProjectPathsExtra.getRootDir(), ".gradle")), (Object)new File(this.$this_installProjectPathsExtra.getRootDir(), ".idea"));
                Collection destination$iv = new TreeSet<E>();
                boolean $i$f$mapTo = false;
                for (E item$iv : $this$mapTo$iv) {
                    void it;
                    File file = (File)item$iv;
                    Collection collection = destination$iv;
                    boolean bl = false;
                    collection.add(it.getAbsolutePath() + File.separatorChar);
                }
                return (TreeSet)var2_2;
            }
        })));
    }

    private final void configurePlugin(Project $this$configurePlugin) {
        $this$configurePlugin.getPlugins().apply(BasePlugin.class);
        Object[] objectArray = new Object[]{$this$configurePlugin};
        Object object = $this$configurePlugin.getExtensions().create("autostyle", AutostyleExtension.class, objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"extensions.create(\n     \u2026           this\n        )");
        AutostyleExtension extension = (AutostyleExtension)object;
        $this$configurePlugin.getConfigurations().detachedConfiguration(new Dependency[0]);
        TaskProvider taskProvider = $this$configurePlugin.getTasks().register("autostyleCheck", new Action($this$configurePlugin){
            final /* synthetic */ Project $this_configurePlugin;
            {
                this.$this_configurePlugin = $receiver;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("Verification");
                $this$register.setDescription("Checks that sourcecode satisfies formatting steps.");
                Object[] objectArray = new Object[1];
                TaskContainer taskContainer = this.$this_configurePlugin.getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
                TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                boolean $i$f$withType = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$withType$iv.withType(AutostyleCheckTask.class), (String)"withType(S::class.java)");
                $this$register.dependsOn(objectArray);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)taskProvider, (String)"Project.configurePlugin(\u2026leCheckTask>())\n        }");
        TaskProvider checkTask2 = taskProvider;
        $this$configurePlugin.getTasks().register("autostyleApply", new Action($this$configurePlugin){
            final /* synthetic */ Project $this_configurePlugin;
            {
                this.$this_configurePlugin = $receiver;
            }

            public final void execute(@NotNull Task $this$register) {
                Intrinsics.checkNotNullParameter((Object)$this$register, (String)"$this$register");
                $this$register.setGroup("Verification");
                $this$register.setDescription("Applies code formatting steps to sourcecode in-place.");
                Object[] objectArray = new Object[1];
                TaskContainer taskContainer = this.$this_configurePlugin.getTasks();
                Intrinsics.checkNotNullExpressionValue((Object)taskContainer, (String)"tasks");
                TaskCollection $this$withType$iv = (TaskCollection)taskContainer;
                boolean $i$f$withType = false;
                Intrinsics.checkNotNullExpressionValue((Object)$this$withType$iv.withType(AutostyleApplyTask.class), (String)"withType(S::class.java)");
                $this$register.dependsOn(objectArray);
            }
        });
        $this$configurePlugin.getGradle().buildFinished((Action)configurePlugin.2.INSTANCE);
        $this$configurePlugin.afterEvaluate(new Action(extension, (TaskProvider<Task>)checkTask2){
            final /* synthetic */ AutostyleExtension $extension;
            final /* synthetic */ TaskProvider<Task> $checkTask;
            {
                this.$extension = $extension;
                this.$checkTask = $checkTask;
            }

            public final void execute(@NotNull Project $this$afterEvaluate) {
                Intrinsics.checkNotNullParameter((Object)$this$afterEvaluate, (String)"$this$afterEvaluate");
                if (this.$extension.isEnforceCheck()) {
                    $this$afterEvaluate.getTasks().named("check", new Action(this.$checkTask){
                        final /* synthetic */ TaskProvider<Task> $checkTask;
                        {
                            this.$checkTask = $checkTask;
                        }

                        public final void execute(@NotNull Task $this$named) {
                            Intrinsics.checkNotNullParameter((Object)$this$named, (String)"$this$named");
                            Object[] objectArray = new Object[]{this.$checkTask};
                            $this$named.dependsOn(objectArray);
                        }
                    });
                }
            }
        });
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/github/autostyle/gradle/AutostylePlugin$Companion;", "", "()V", "APPLY_DESCRIPTION", "", "CHECK_DESCRIPTION", "FILES_PROPERTY", "PROJECT_DIR_MAP", "TASK_GROUP", "autostyle-plugin-gradle"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

