/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.ConvergenceAnalyzer;
import com.github.autostyle.ConvergenceResult;
import com.github.autostyle.Formatter;
import com.github.autostyle.FormatterStep;
import com.github.autostyle.LineEnding;
import com.github.autostyle.gradle.ext.GradleExtensionsKt;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileType;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.ChangeType;
import org.gradle.work.FileChange;
import org.gradle.work.InputChanges;
import org.jetbrains.annotations.NotNull;

@CacheableTask
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\b'\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020 J\u001e\u0010&\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00190(H\u0002J\u0010\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+H\u0007J.\u0010,\u001a\u00020$2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u00192\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000b00H\u0002R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u0010\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00140\u00140\n8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000eR\u0016\u0010\u0016\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\bR\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00020\u001b8G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0019\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f8G\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u00061"}, d2={"Lcom/github/autostyle/gradle/AutostyleTask;", "Lorg/gradle/api/DefaultTask;", "objects", "Lorg/gradle/api/model/ObjectFactory;", "(Lorg/gradle/api/model/ObjectFactory;)V", "divergingDirectory", "Lorg/gradle/api/file/DirectoryProperty;", "getDivergingDirectory", "()Lorg/gradle/api/file/DirectoryProperty;", "encoding", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getEncoding", "()Lorg/gradle/api/provider/Property;", "formatter", "Lcom/github/autostyle/Formatter;", "getFormatter", "()Lcom/github/autostyle/Formatter;", "lineEndingsPolicy", "Lcom/github/autostyle/LineEnding$Policy;", "getLineEndingsPolicy", "outputDirectory", "getOutputDirectory", "projectDirectory", "Ljava/io/File;", "sourceFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSourceFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "steps", "Lorg/gradle/api/provider/ListProperty;", "Lcom/github/autostyle/FormatterStep;", "getSteps", "()Lorg/gradle/api/provider/ListProperty;", "addStep", "", "step", "formatFiles", "filesToCheck", "", "run", "inputChanges", "Lorg/gradle/work/InputChanges;", "storeCycle", "divergingDir", "relativeFile", "cycle", "", "autostyle-plugin-gradle"})
@SourceDebugExtension(value={"SMAP\nAutostyleTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AutostyleTask.kt\ncom/github/autostyle/gradle/AutostyleTask\n+ 2 ObjectFactoryExtensions.kt\norg/gradle/kotlin/dsl/ObjectFactoryExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,165:1\n59#2:166\n59#2:167\n77#2:168\n1855#3,2:169\n1#4:171\n*S KotlinDebug\n*F\n+ 1 AutostyleTask.kt\ncom/github/autostyle/gradle/AutostyleTask\n*L\n47#1:166\n50#1:167\n54#1:168\n96#1:169,2\n*E\n"})
public abstract class AutostyleTask
extends DefaultTask {
    @NotNull
    private final Property<String> encoding;
    @NotNull
    private final Property<LineEnding.Policy> lineEndingsPolicy;
    @NotNull
    private final ListProperty<FormatterStep> steps;
    @NotNull
    private final ConfigurableFileCollection sourceFiles;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty outputDirectory;
    @OutputDirectory
    @NotNull
    private final DirectoryProperty divergingDirectory;
    @NotNull
    private final File projectDirectory;

    @Inject
    public AutostyleTask(@NotNull ObjectFactory objects) {
        Intrinsics.checkNotNullParameter((Object)objects, (String)"objects");
        String string = System.getenv("JITPACK");
        boolean bl = string != null ? Boolean.parseBoolean(string) : false;
        if (bl) {
            this.setEnabled(false);
        }
        ObjectFactory $this$property$iv = objects;
        boolean $i$f$property = false;
        Property property = $this$property$iv.property(String.class);
        Intrinsics.checkNotNullExpressionValue((Object)property, (String)"property(T::class.java)");
        this.encoding = GradleExtensionsKt.conv(property, "UTF-8");
        $this$property$iv = objects;
        $i$f$property = false;
        Property property2 = $this$property$iv.property(LineEnding.Policy.class);
        Intrinsics.checkNotNullExpressionValue((Object)property2, (String)"property(T::class.java)");
        LineEnding.Policy policy = LineEnding.UNIX.createPolicy();
        Intrinsics.checkNotNullExpressionValue((Object)policy, (String)"UNIX.createPolicy()");
        this.lineEndingsPolicy = GradleExtensionsKt.conv(property2, policy);
        ObjectFactory $this$listProperty$iv = objects;
        boolean $i$f$listProperty = false;
        ListProperty listProperty = $this$listProperty$iv.listProperty(FormatterStep.class);
        Intrinsics.checkNotNullExpressionValue((Object)listProperty, (String)"listProperty(T::class.java)");
        this.steps = listProperty;
        ConfigurableFileCollection configurableFileCollection = this.getProject().files(new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)configurableFileCollection, (String)"project.files()");
        this.sourceFiles = configurableFileCollection;
        DirectoryProperty directoryProperty = objects.directoryProperty().convention(this.getProject().getLayout().getBuildDirectory().dir("autostyle/" + this.getName() + "/formatted"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty, (String)"objects.directoryPropert\u2026ostyle/$name/formatted\"))");
        this.outputDirectory = directoryProperty;
        DirectoryProperty directoryProperty2 = objects.directoryProperty().convention(this.getProject().getLayout().getBuildDirectory().dir("autostyle/" + this.getName() + "/diverging"));
        Intrinsics.checkNotNullExpressionValue((Object)directoryProperty2, (String)"objects.directoryPropert\u2026ostyle/$name/diverging\"))");
        this.divergingDirectory = directoryProperty2;
        File file = this.getProject().getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.projectDir");
        this.projectDirectory = file;
    }

    @Input
    @NotNull
    public final Property<String> getEncoding() {
        return this.encoding;
    }

    @Input
    @NotNull
    public final Property<LineEnding.Policy> getLineEndingsPolicy() {
        return this.lineEndingsPolicy;
    }

    @Input
    @NotNull
    public final ListProperty<FormatterStep> getSteps() {
        return this.steps;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @NotNull
    public final ConfigurableFileCollection getSourceFiles() {
        return this.sourceFiles;
    }

    public final void addStep(@NotNull FormatterStep step) {
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        this.steps.add((Object)step);
    }

    @NotNull
    public final DirectoryProperty getOutputDirectory() {
        return this.outputDirectory;
    }

    @NotNull
    public final DirectoryProperty getDivergingDirectory() {
        return this.divergingDirectory;
    }

    @Internal
    @NotNull
    public final Formatter getFormatter() {
        Formatter formatter = Formatter.builder().lineEndingsPolicy((LineEnding.Policy)this.lineEndingsPolicy.get()).encoding(Charset.forName((String)this.encoding.get())).rootDir(this.getProject().getRootDir().toPath()).steps((List)this.steps.get()).build();
        Intrinsics.checkNotNullExpressionValue((Object)formatter, (String)"builder()\n              \u2026\n                .build()");
        return formatter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TaskAction
    public final void run(@NotNull InputChanges inputChanges) {
        Intrinsics.checkNotNullParameter((Object)inputChanges, (String)"inputChanges");
        File file = ((Directory)this.outputDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.get().asFile");
        File outputDir = file;
        if (!inputChanges.isIncremental()) {
            Object[] objectArray = new Object[]{outputDir};
            this.getProject().delete(objectArray);
        }
        this.getProject().mkdir((Object)outputDir);
        File file2 = ((Directory)this.divergingDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"divergingDirectory.get().asFile");
        File divergingDir = file2;
        Object[] objectArray = new Object[]{divergingDir};
        this.getProject().delete(objectArray);
        this.getProject().mkdir((Object)divergingDir);
        List filesToCheck = new ArrayList();
        Iterable iterable = inputChanges.getFileChanges((FileCollection)this.sourceFiles);
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"inputChanges.getFileChanges(sourceFiles)");
        Iterable $this$forEach$iv = iterable;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileChange it = (FileChange)element$iv;
            boolean bl = false;
            if (it.getChangeType() == ChangeType.REMOVED) {
                File file3 = it.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"it.file");
                File outFile = FilesKt.resolve((File)outputDir, (File)FilesKt.relativeTo((File)file3, (File)this.projectDirectory));
                Object[] objectArray2 = new Object[]{outFile};
                this.getProject().delete(objectArray2);
            }
            if (it.getChangeType() == ChangeType.REMOVED || it.getFileType() != FileType.FILE) continue;
            File file4 = it.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"it.file");
            filesToCheck.add(file4);
        }
        AutoCloseable autoCloseable = (AutoCloseable)this.getFormatter();
        Throwable throwable = null;
        try {
            Formatter it = (Formatter)autoCloseable;
            boolean bl = false;
            this.formatFiles(it, filesToCheck);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private final void formatFiles(Formatter formatter, Collection<? extends File> filesToCheck) {
        File file = ((Directory)this.outputDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"outputDirectory.get().asFile");
        File outputDir = file;
        File file2 = ((Directory)this.divergingDirectory.get()).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"divergingDirectory.get().asFile");
        File divergingDir = file2;
        ConvergenceAnalyzer convergenceAnalyzer = new ConvergenceAnalyzer(formatter, 0, 2, null);
        List diverges = new ArrayList();
        List cycles = new ArrayList();
        for (File file3 : filesToCheck) {
            this.getLogger().debug("Applying format to {}", (Object)file3);
            ConvergenceResult result = convergenceAnalyzer.analyze(file3);
            File relativeFile = FilesKt.relativeTo((File)file3, (File)this.projectDirectory);
            File outFile = FilesKt.resolve((File)outputDir, (File)relativeFile);
            outFile.getParentFile().mkdirs();
            ConvergenceResult convergenceResult = result;
            if (convergenceResult instanceof ConvergenceResult.Clean) {
                Object[] objectArray = new Object[]{outFile};
                this.getProject().delete(objectArray);
                continue;
            }
            if (convergenceResult instanceof ConvergenceResult.Convergence) {
                String string = result.getFormatted();
                Charset charset = formatter.getEncoding();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"formatter.encoding");
                FilesKt.writeText((File)outFile, (String)string, (Charset)charset);
                continue;
            }
            if (convergenceResult instanceof ConvergenceResult.Cycle) {
                this.storeCycle(formatter, divergingDir, relativeFile, ((ConvergenceResult.Cycle)result).getCycle());
                ((Collection)cycles).add(relativeFile.toString());
                continue;
            }
            if (!(convergenceResult instanceof ConvergenceResult.Divergence)) continue;
            this.storeCycle(formatter, divergingDir, relativeFile, ((ConvergenceResult.Divergence)result).getCycle());
            ((Collection)diverges).add(relativeFile.toString());
        }
        if (diverges.isEmpty() && cycles.isEmpty()) {
            return;
        }
        throw new GradleException(StringsKt.removeSuffix((String)("Formatting " + StringsKt.removeSuffix((String)CollectionsKt.joinToString$default((Iterable)cycles, null, (CharSequence)"cycles for ", (CharSequence)", ", (int)0, null, null, (int)57, null), (CharSequence)"cycles for , ") + StringsKt.removeSuffix((String)CollectionsKt.joinToString$default((Iterable)diverges, null, (CharSequence)"diverges for ", null, (int)0, null, null, (int)61, null), (CharSequence)"diverges for ")), (CharSequence)", "));
    }

    private final void storeCycle(Formatter formatter, File divergingDir, File relativeFile, List<String> cycle) {
        File outFile = FilesKt.resolve((File)divergingDir, (File)relativeFile);
        this.getProject().mkdir((Object)outFile.getParentFile());
        String outPath = outFile.getAbsolutePath();
        Iterator<String> iterator = cycle.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int index = n++;
            String value = iterator.next();
            File file = new File(outPath + '.' + StringsKt.padStart((String)String.valueOf(index), (int)2, (char)'0'));
            Charset charset = formatter.getEncoding();
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"formatter.encoding");
            FilesKt.writeText((File)file, (String)value, (Charset)charset);
        }
    }
}

