/*
 * Decompiled with CFR 0.152.
 */
package com.github.autostyle.gradle;

import com.github.autostyle.FormatterStep;
import com.github.autostyle.Provisioner;
import com.github.autostyle.gradle.AutostyleExtension;
import com.github.autostyle.gradle.BaseFormatExtension;
import com.github.autostyle.gradle.ext.GradleExtensionsKt;
import com.github.autostyle.java.GoogleJavaFormatStep;
import com.github.autostyle.java.ImportOrderStep;
import com.github.autostyle.java.RemoveUnusedImportsStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.reflect.TypeOf;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.SourceSetContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0011B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J$\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00032\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u001f\u0010\r\u001a\u00020\b2\u0012\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u000e\"\u00020\u0003\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\b\u00a8\u0006\u0012"}, d2={"Lcom/github/autostyle/gradle/JavaExtension;", "Lcom/github/autostyle/gradle/BaseFormatExtension;", "name", "", "root", "Lcom/github/autostyle/gradle/AutostyleExtension;", "(Ljava/lang/String;Lcom/github/autostyle/gradle/AutostyleExtension;)V", "googleJavaFormat", "", "version", "action", "Lorg/gradle/api/Action;", "Lcom/github/autostyle/gradle/JavaExtension$GoogleJavaFormatConfig;", "importOrder", "", "([Ljava/lang/String;)V", "removeUnusedImports", "GoogleJavaFormatConfig", "autostyle-plugin-gradle"})
public class JavaExtension
extends BaseFormatExtension {
    @Inject
    public JavaExtension(@NotNull String name, @NotNull AutostyleExtension root) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        super(name, root);
        ListProperty<Object> listProperty = this.getTarget();
        Provider provider = root.getProviders$autostyle_plugin_gradle().provider(new Callable(){

            /*
             * WARNING - void declaration
             */
            public final List<SourceDirectorySet> call() {
                void $this$mapTo$iv$iv;
                ExtensionContainer extensionContainer = this.getProject().getExtensions();
                Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
                ExtensionContainer $this$findByType$iv = extensionContainer;
                boolean $i$f$findByType22 = false;
                boolean $i$f$typeOf = false;
                JavaPluginExtension javaPluginExtension = (JavaPluginExtension)$this$findByType$iv.findByType((TypeOf)new TypeOf<JavaPluginExtension>(){});
                if (javaPluginExtension == null) {
                    throw new GradleException("You must apply the java plugin before the Autostyle plugin if you are using the java extension.");
                }
                JavaPluginExtension java = javaPluginExtension;
                SourceSetContainer sourceSetContainer = java.getSourceSets();
                Intrinsics.checkNotNullExpressionValue((Object)sourceSetContainer, (String)"java.sourceSets");
                Iterable $this$map$iv = (Iterable)sourceSetContainer;
                boolean $i$f$map = false;
                Iterable $i$f$findByType22 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    SourceSet sourceSet = (SourceSet)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAllJava());
                }
                return (List)destination$iv$iv;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"root.providers.provider \u2026 { it.allJava }\n        }");
        GradleExtensionsKt.conv(listProperty, provider);
    }

    public final void importOrder(String ... importOrder) {
        Intrinsics.checkNotNullParameter((Object)importOrder, (String)"importOrder");
        FormatterStep formatterStep = ImportOrderStep.forJava().createFrom(Arrays.copyOf(importOrder, importOrder.length));
        Intrinsics.checkNotNullExpressionValue((Object)formatterStep, (String)"forJava().createFrom(*importOrder)");
        this.addStep(formatterStep);
    }

    public final void removeUnusedImports() {
        FormatterStep formatterStep = RemoveUnusedImportsStep.create((Provisioner)GradleExtensionsKt.asProvisioner(this.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)formatterStep, (String)"create(project.asProvisioner())");
        this.addStep(formatterStep);
    }

    public final void googleJavaFormat(@NotNull Action<GoogleJavaFormatConfig> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        String string = GoogleJavaFormatStep.defaultVersion();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultVersion()");
        this.googleJavaFormat(string, action);
    }

    @JvmOverloads
    public final void googleJavaFormat(@NotNull String version, @Nullable Action<GoogleJavaFormatConfig> action) {
        GoogleJavaFormatConfig googleJavaFormatConfig;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        GoogleJavaFormatConfig it = googleJavaFormatConfig = new GoogleJavaFormatConfig(version, this.getProject());
        boolean bl = false;
        Action<GoogleJavaFormatConfig> action2 = action;
        if (action2 != null) {
            action2.execute((Object)it);
        }
        this.addStep(it.createStep$autostyle_plugin_gradle());
    }

    public static /* synthetic */ void googleJavaFormat$default(JavaExtension javaExtension, String string, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: googleJavaFormat");
        }
        if ((n & 1) != 0) {
            String string2 = GoogleJavaFormatStep.defaultVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"defaultVersion()");
            string = string2;
        }
        if ((n & 2) != 0) {
            action = null;
        }
        javaExtension.googleJavaFormat(string, (Action<GoogleJavaFormatConfig>)action);
    }

    @JvmOverloads
    public final void googleJavaFormat(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        JavaExtension.googleJavaFormat$default(this, version, null, 2, null);
    }

    @JvmOverloads
    public final void googleJavaFormat() {
        JavaExtension.googleJavaFormat$default(this, null, null, 3, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000f\u001a\u00020\u0010J\r\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\t\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/github/autostyle/gradle/JavaExtension$GoogleJavaFormatConfig;", "", "version", "", "project", "Lorg/gradle/api/Project;", "(Ljava/lang/String;Lorg/gradle/api/Project;)V", "getProject", "()Lorg/gradle/api/Project;", "style", "getStyle", "()Ljava/lang/String;", "setStyle", "(Ljava/lang/String;)V", "getVersion", "aosp", "", "createStep", "Lcom/github/autostyle/FormatterStep;", "createStep$autostyle_plugin_gradle", "autostyle-plugin-gradle"})
    public static final class GoogleJavaFormatConfig {
        @NotNull
        private final String version;
        @NotNull
        private final Project project;
        @NotNull
        private String style;

        public GoogleJavaFormatConfig(@NotNull String version, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.version = version;
            this.project = project;
            String string = GoogleJavaFormatStep.defaultStyle();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"defaultStyle()");
            this.style = string;
        }

        @NotNull
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final String getStyle() {
            return this.style;
        }

        public final void setStyle(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.style = string;
        }

        public final void style(@NotNull String style) {
            Intrinsics.checkNotNullParameter((Object)style, (String)"style");
            this.style = style;
        }

        public final void aosp() {
            this.style("AOSP");
        }

        @NotNull
        public final FormatterStep createStep$autostyle_plugin_gradle() {
            FormatterStep formatterStep = GoogleJavaFormatStep.create((String)this.version, (String)this.style, (Provisioner)GradleExtensionsKt.asProvisioner(this.project));
            Intrinsics.checkNotNullExpressionValue((Object)formatterStep, (String)"create(\n            vers\u2026asProvisioner()\n        )");
            return formatterStep;
        }
    }
}

