/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFloatConverter;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AudioDispatcher
implements Runnable {
    private static final Logger LOG = Logger.getLogger(AudioDispatcher.class.getName());
    private final TarsosDSPAudioInputStream audioInputStream;
    private float[] audioFloatBuffer;
    private byte[] audioByteBuffer;
    private final List<AudioProcessor> audioProcessors = new CopyOnWriteArrayList<AudioProcessor>();
    private final TarsosDSPAudioFloatConverter converter;
    private final TarsosDSPAudioFormat format;
    private int floatOverlap;
    private int floatStepSize;
    private int byteOverlap;
    private int byteStepSize;
    private long bytesToSkip;
    private long bytesProcessed;
    private AudioEvent audioEvent;
    private boolean stopped;
    private boolean zeroPadFirstBuffer;
    private boolean zeroPadLastBuffer;

    public AudioDispatcher(TarsosDSPAudioInputStream tarsosDSPAudioInputStream, int n, int n2) {
        this.audioInputStream = tarsosDSPAudioInputStream;
        this.format = this.audioInputStream.getFormat();
        this.setStepSizeAndOverlap(n, n2);
        this.audioEvent = new AudioEvent(this.format);
        this.audioEvent.setFloatBuffer(this.audioFloatBuffer);
        this.audioEvent.setOverlap(n2);
        this.converter = TarsosDSPAudioFloatConverter.getConverter(this.format);
        this.stopped = false;
        this.bytesToSkip = 0L;
        this.zeroPadLastBuffer = true;
    }

    public void skip(double d) {
        this.bytesToSkip = Math.round(d * (double)this.format.getSampleRate()) * (long)this.format.getFrameSize();
    }

    public void setStepSizeAndOverlap(int n, int n2) {
        this.audioFloatBuffer = new float[n];
        this.floatOverlap = n2;
        this.floatStepSize = this.audioFloatBuffer.length - this.floatOverlap;
        this.audioByteBuffer = new byte[this.audioFloatBuffer.length * this.format.getFrameSize()];
        this.byteOverlap = this.floatOverlap * this.format.getFrameSize();
        this.byteStepSize = this.floatStepSize * this.format.getFrameSize();
    }

    public void setZeroPadFirstBuffer(boolean bl) {
        this.zeroPadFirstBuffer = bl;
    }

    public void setZeroPadLastBuffer(boolean bl) {
        this.zeroPadLastBuffer = bl;
    }

    public void addAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessors.add(audioProcessor);
        LOG.fine("Added an audioprocessor to the list of processors: " + audioProcessor.toString());
    }

    public void removeAudioProcessor(AudioProcessor audioProcessor) {
        this.audioProcessors.remove(audioProcessor);
        audioProcessor.processingFinished();
        LOG.fine("Remove an audioprocessor to the list of processors: " + audioProcessor.toString());
    }

    @Override
    public void run() {
        int n = 0;
        if (this.bytesToSkip != 0L) {
            this.skipToStart();
        }
        try {
            this.audioEvent.setBytesProcessed(this.bytesProcessed);
            n = this.readNextAudioBlock();
        }
        catch (IOException iOException) {
            String string = "Error while reading audio input stream: " + iOException.getMessage();
            LOG.warning(string);
            throw new Error(string);
        }
        while (n != 0 && !this.stopped) {
            for (AudioProcessor object : this.audioProcessors) {
                if (!object.process(this.audioEvent)) break;
            }
            if (this.stopped) continue;
            this.bytesProcessed += (long)n;
            this.audioEvent.setBytesProcessed(this.bytesProcessed);
            try {
                n = this.readNextAudioBlock();
                this.audioEvent.setOverlap(this.floatOverlap);
            }
            catch (IOException iOException) {
                String string = "Error while reading audio input stream: " + iOException.getMessage();
                LOG.warning(string);
                throw new Error(string);
            }
        }
        if (!this.stopped) {
            this.stop();
        }
    }

    private void skipToStart() {
        long l = 0L;
        try {
            l = this.audioInputStream.skip(this.bytesToSkip);
            if (l != this.bytesToSkip) {
                throw new IOException();
            }
            this.bytesProcessed += this.bytesToSkip;
        }
        catch (IOException iOException) {
            String string = String.format("Did not skip the expected amount of bytes,  %d skipped, %d expected!", l, this.bytesToSkip);
            LOG.warning(string);
            throw new Error(string);
        }
    }

    public void stop() {
        this.stopped = true;
        for (AudioProcessor audioProcessor : this.audioProcessors) {
            audioProcessor.processingFinished();
        }
        try {
            this.audioInputStream.close();
        }
        catch (IOException iOException) {
            LOG.log(Level.SEVERE, "Closing audio stream error.", iOException);
        }
    }

    private int readNextAudioBlock() throws IOException {
        int n;
        int n2;
        int n3;
        boolean bl;
        assert (this.floatOverlap < this.audioFloatBuffer.length);
        boolean bl2 = bl = this.bytesProcessed == 0L || this.bytesProcessed == this.bytesToSkip;
        if (bl && !this.zeroPadFirstBuffer) {
            n3 = this.audioByteBuffer.length;
            n2 = 0;
            n = 0;
        } else {
            n3 = this.byteStepSize;
            n2 = this.byteOverlap;
            n = this.floatOverlap;
        }
        if (!bl && this.audioFloatBuffer.length == this.floatOverlap + this.floatStepSize) {
            System.arraycopy(this.audioFloatBuffer, this.floatStepSize, this.audioFloatBuffer, 0, this.floatOverlap);
        }
        int n4 = 0;
        int n5 = 0;
        boolean bl3 = false;
        while (!this.stopped && !bl3 && n4 < n3) {
            try {
                n5 = this.audioInputStream.read(this.audioByteBuffer, n2 + n4, n3 - n4);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n5 = -1;
            }
            if (n5 == -1) {
                bl3 = true;
                continue;
            }
            n4 += n5;
        }
        if (bl3) {
            if (this.zeroPadLastBuffer) {
                for (int i = n2 + n4; i < this.audioByteBuffer.length; ++i) {
                    this.audioByteBuffer[i] = 0;
                }
                this.converter.toFloatArray(this.audioByteBuffer, n2, this.audioFloatBuffer, n, this.floatStepSize);
            } else {
                int n6;
                byte[] byArray = this.audioByteBuffer;
                this.audioByteBuffer = new byte[n2 + n4];
                for (n6 = 0; n6 < this.audioByteBuffer.length; ++n6) {
                    this.audioByteBuffer[n6] = byArray[n6];
                }
                n6 = n4 / this.format.getFrameSize();
                this.audioFloatBuffer = new float[n + n4 / this.format.getFrameSize()];
                this.converter.toFloatArray(this.audioByteBuffer, n2, this.audioFloatBuffer, n, n6);
            }
        } else if (n3 == n4) {
            if (bl && !this.zeroPadFirstBuffer) {
                this.converter.toFloatArray(this.audioByteBuffer, 0, this.audioFloatBuffer, 0, this.audioFloatBuffer.length);
            } else {
                this.converter.toFloatArray(this.audioByteBuffer, n2, this.audioFloatBuffer, n, this.floatStepSize);
            }
        } else if (!this.stopped) {
            throw new IOException(String.format("The end of the audio stream has not been reached and the number of bytes read (%d) is not equal to the expected amount of bytes(%d).", n4, n3));
        }
        this.audioEvent.setFloatBuffer(this.audioFloatBuffer);
        this.audioEvent.setOverlap(n);
        return n4;
    }

    public TarsosDSPAudioFormat getFormat() {
        return this.format;
    }

    public float secondsProcessed() {
        return (float)(this.bytesProcessed / (long)(this.format.getSampleSizeInBits() / 8)) / this.format.getSampleRate() / (float)this.format.getChannels();
    }

    public void setAudioFloatBuffer(float[] fArray) {
        this.audioFloatBuffer = fArray;
    }

    public boolean isStopped() {
        return this.stopped;
    }
}

