/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.io.TarsosDSPAudioFloatConverter;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import java.util.Arrays;

public class AudioEvent {
    private final TarsosDSPAudioFormat format;
    private final TarsosDSPAudioFloatConverter converter;
    private float[] floatBuffer;
    private byte[] byteBuffer;
    private int overlap;
    private long frameLength;
    private long bytesProcessed;
    private int bytesProcessing;

    public AudioEvent(TarsosDSPAudioFormat tarsosDSPAudioFormat) {
        this.format = tarsosDSPAudioFormat;
        this.converter = TarsosDSPAudioFloatConverter.getConverter(tarsosDSPAudioFormat);
        this.overlap = 0;
    }

    public float getSampleRate() {
        return this.format.getSampleRate();
    }

    public int getBufferSize() {
        return this.getFloatBuffer().length;
    }

    public long getFrameLength() {
        return this.frameLength;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public void setOverlap(int n) {
        this.overlap = n;
    }

    public void setBytesProcessed(long l) {
        this.bytesProcessed = l;
    }

    public double getTimeStamp() {
        return (float)(this.bytesProcessed / (long)this.format.getFrameSize()) / this.format.getSampleRate();
    }

    public double getEndTimeStamp() {
        return (float)((this.bytesProcessed + (long)this.bytesProcessing) / (long)this.format.getFrameSize()) / this.format.getSampleRate();
    }

    public long getSamplesProcessed() {
        return this.bytesProcessed / (long)this.format.getFrameSize();
    }

    public double getProgress() {
        return (double)(this.bytesProcessed / (long)this.format.getFrameSize()) / (double)this.frameLength;
    }

    public byte[] getByteBuffer() {
        int n = this.getFloatBuffer().length * this.format.getFrameSize();
        if (this.byteBuffer == null || this.byteBuffer.length != n) {
            this.byteBuffer = new byte[n];
        }
        this.converter.toByteArray(this.getFloatBuffer(), this.byteBuffer);
        return this.byteBuffer;
    }

    public void setFloatBuffer(float[] fArray) {
        this.floatBuffer = fArray;
    }

    public float[] getFloatBuffer() {
        return this.floatBuffer;
    }

    public double getRMS() {
        return AudioEvent.calculateRMS(this.floatBuffer);
    }

    public double getdBSPL() {
        return this.soundPressureLevel(this.floatBuffer);
    }

    public static double calculateRMS(float[] fArray) {
        double d = 0.0;
        for (int i = 0; i < fArray.length; ++i) {
            d += (double)(fArray[i] * fArray[i]);
        }
        d /= Double.valueOf(fArray.length).doubleValue();
        d = Math.sqrt(d);
        return d;
    }

    public void clearFloatBuffer() {
        Arrays.fill(this.floatBuffer, 0.0f);
    }

    private double soundPressureLevel(float[] fArray) {
        double d = Math.pow(this.localEnergy(fArray), 0.5);
        return this.linearToDecibel(d /= (double)fArray.length);
    }

    private double localEnergy(float[] fArray) {
        double d = 0.0;
        for (float f : fArray) {
            d += (double)(f * f);
        }
        return d;
    }

    private double linearToDecibel(double d) {
        return 20.0 * Math.log10(d);
    }

    public boolean isSilence(double d) {
        return this.soundPressureLevel(this.floatBuffer) < d;
    }

    public void setBytesProcessing(int n) {
        this.bytesProcessing = n;
    }
}

