/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.fft.FFT;

public class ConstantQ
implements AudioProcessor {
    private final float minimumFrequency;
    private final float maximumFreqency;
    private int fftLength;
    private final float[] frequencies;
    private final float[][] qKernel;
    private final int[][] qKernel_indexes;
    private final float[] coefficients;
    private final float[] magnitudes;
    private int binsPerOctave;
    private FFT fft;

    public ConstantQ(float f, float f2, float f3, float f4) {
        this(f, f2, f3, f4, 0.001f, 1.0f);
    }

    public ConstantQ(float f, float f2, float f3, float f4, float f5, float f6) {
        this.minimumFrequency = f2;
        this.maximumFreqency = f3;
        this.binsPerOctave = (int)f4;
        double d = 1.0 / (Math.pow(2.0, 1.0 / (double)f4) - 1.0) / (double)f6;
        int n = (int)Math.ceil((double)f4 * Math.log(this.maximumFreqency / this.minimumFrequency) / Math.log(2.0));
        this.coefficients = new float[n * 2];
        this.magnitudes = new float[n];
        float f7 = (float)Math.ceil(d * (double)f / (double)this.minimumFrequency);
        this.fftLength = (int)f7;
        this.fftLength = (int)Math.pow(2.0, Math.ceil(Math.log(f7) / Math.log(2.0)));
        this.fft = new FFT(this.fftLength);
        this.qKernel = new float[n][];
        this.qKernel_indexes = new int[n][];
        this.frequencies = new float[n];
        float[] fArray = new float[this.fftLength * 2];
        float[] fArray2 = new float[this.fftLength * 2];
        int[] nArray = new int[this.fftLength];
        for (int i = 0; i < n; ++i) {
            int n2;
            float[] fArray3 = fArray;
            this.frequencies[i] = (float)((double)this.minimumFrequency * Math.pow(2.0, (float)i / f4));
            int n3 = (int)Math.min(Math.ceil(d * (double)f / (double)this.frequencies[i]), (double)this.fftLength);
            for (n2 = 0; n2 < n3; ++n2) {
                double d2 = -0.5 * Math.cos(Math.PI * 2 * (double)n2 / (double)n3) + 0.5;
                double d3 = Math.PI * 2 * d * (double)n2 / (double)n3;
                fArray3[n2 * 2] = (float)((d2 /= (double)n3) * Math.cos(d3));
                fArray3[n2 * 2 + 1] = (float)(d2 * Math.sin(d3));
            }
            for (n2 = n3 * 2; n2 < this.fftLength * 2; ++n2) {
                fArray3[n2] = 0.0f;
            }
            this.fft.complexForwardTransform(fArray3);
            float[] fArray4 = fArray2;
            int n4 = 0;
            int n5 = 0;
            int n6 = fArray3.length - 2;
            while (n5 < fArray3.length / 2) {
                double d4 = Math.sqrt(fArray3[n5] * fArray3[n5] + fArray3[n5 + 1] * fArray3[n5 + 1]);
                if ((d4 += Math.sqrt(fArray3[n6] * fArray3[n6] + fArray3[n6 + 1] * fArray3[n6 + 1])) > (double)f5) {
                    nArray[n4] = n5;
                    fArray4[2 * n4] = fArray3[n5] + fArray3[n6];
                    fArray4[2 * n4 + 1] = fArray3[n5 + 1] + fArray3[n6 + 1];
                    ++n4;
                }
                n5 += 2;
                n6 -= 2;
            }
            fArray3 = new float[n4 * 2];
            int[] nArray2 = new int[n4];
            for (n6 = 0; n6 < n4 * 2; ++n6) {
                fArray3[n6] = fArray4[n6];
            }
            for (n6 = 0; n6 < n4; ++n6) {
                nArray2[n6] = nArray[n6];
            }
            n6 = 0;
            while (n6 < fArray3.length) {
                int n7 = n6++;
                fArray3[n7] = fArray3[n7] / (float)this.fftLength;
            }
            for (n6 = 1; n6 < fArray3.length; n6 += 2) {
                fArray3[n6] = -fArray3[n6];
            }
            for (n6 = 0; n6 < fArray3.length; ++n6) {
                fArray3[n6] = -fArray3[n6];
            }
            this.qKernel_indexes[i] = nArray2;
            this.qKernel[i] = fArray3;
        }
    }

    public void calculate(float[] fArray) {
        this.fft.forwardTransform(fArray);
        for (int i = 0; i < this.qKernel.length; ++i) {
            float[] fArray2 = this.qKernel[i];
            int[] nArray = this.qKernel_indexes[i];
            float f = 0.0f;
            float f2 = 0.0f;
            int n = 0;
            int n2 = 0;
            while (n < fArray2.length) {
                int n3 = nArray[n2];
                float f3 = fArray[n3];
                float f4 = fArray[n3 + 1];
                float f5 = fArray2[n];
                float f6 = fArray2[n + 1];
                f += f3 * f5 - f4 * f6;
                f2 += f3 * f6 + f4 * f5;
                n += 2;
                ++n2;
            }
            this.coefficients[i * 2] = f;
            this.coefficients[i * 2 + 1] = f2;
        }
    }

    public void calculateMagintudes(float[] fArray) {
        this.calculate(fArray);
        for (int i = 0; i < this.magnitudes.length; ++i) {
            this.magnitudes[i] = (float)Math.sqrt(this.coefficients[i * 2] * this.coefficients[i * 2] + this.coefficients[i * 2 + 1] * this.coefficients[i * 2 + 1]);
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = (float[])audioEvent.getFloatBuffer().clone();
        if (fArray.length != this.getFFTlength()) {
            throw new IllegalArgumentException(String.format("The length of the fft (%d) should be the same as the length of the audio buffer (%d)", this.getFFTlength(), fArray.length));
        }
        this.calculateMagintudes(fArray);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public float[] getFreqencies() {
        return this.frequencies;
    }

    public float[] getMagnitudes() {
        return this.magnitudes;
    }

    public float[] getCoefficients() {
        return this.coefficients;
    }

    public int getNumberOfOutputBands() {
        return this.frequencies.length;
    }

    public int getFFTlength() {
        return this.fftLength;
    }

    public int getBinsPerOctave() {
        return this.binsPerOctave;
    }
}

