/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class EnvelopeFollower
implements AudioProcessor {
    private static final double DEFAULT_ATTACK_TIME = 2.0E-4;
    private static final double DEFAULT_RELEASE_TIME = 4.0E-4;
    float gainAttack;
    float gainRelease;
    float envelopeOut = 0.0f;

    public EnvelopeFollower(double d) {
        this(d, 2.0E-4, 4.0E-4);
    }

    public EnvelopeFollower(double d, double d2, double d3) {
        this.gainAttack = (float)Math.exp(-1.0 / (d * d2));
        this.gainRelease = (float)Math.exp(-1.0 / (d * d3));
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        this.calculateEnvelope(fArray);
        return true;
    }

    public void calculateEnvelope(float[] fArray) {
        for (int i = 0; i < fArray.length; ++i) {
            float f = Math.abs(fArray[i]);
            this.envelopeOut = this.envelopeOut < f ? f + this.gainAttack * (this.envelopeOut - f) : f + this.gainRelease * (this.envelopeOut - f);
            fArray[i] = this.envelopeOut;
        }
    }

    @Override
    public void processingFinished() {
    }
}

