/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class GainProcessor
implements AudioProcessor {
    private double gain;

    public GainProcessor(double d) {
        this.setGain(d);
    }

    public void setGain(double d) {
        this.gain = d;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        for (int i = audioEvent.getOverlap(); i < fArray.length; ++i) {
            float f = (float)((double)fArray[i] * this.gain);
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < -1.0f) {
                f = -1.0f;
            }
            fArray[i] = f;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

