/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class MultichannelToMono
implements AudioProcessor {
    private int channels;
    private boolean mean;

    public MultichannelToMono(int n, boolean bl) {
        this.channels = n;
        this.mean = bl;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        float[] fArray2 = new float[fArray.length / this.channels];
        if (this.mean) {
            if (this.channels == 2) {
                for (int i = 0; i < fArray.length; i += this.channels) {
                    fArray2[i / this.channels] = (fArray[i] + fArray[i + 1]) / 2.0f;
                }
            } else {
                for (int i = 0; i < fArray.length; i += this.channels) {
                    double d = 0.0;
                    for (int j = 0; j < this.channels; ++j) {
                        d += (double)fArray[i + j];
                    }
                    fArray2[i / this.channels] = (float)(d / (double)this.channels);
                }
            }
        } else {
            for (int i = 0; i < fArray.length; i += this.channels) {
                fArray2[i / this.channels] = fArray[i];
            }
        }
        audioEvent.setFloatBuffer(fArray2);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

