/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class Oscilloscope
implements AudioProcessor {
    float[] dataBuffer;
    private final OscilloscopeEventHandler handler;

    public Oscilloscope(OscilloscopeEventHandler oscilloscopeEventHandler) {
        this.handler = oscilloscopeEventHandler;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        int n = 0;
        float f = 0.0f;
        for (int i = 0; i < fArray.length / 4; ++i) {
            float f2 = fArray[i + 1] - fArray[i];
            if (!(f2 > f)) continue;
            n = i;
            f = f2;
        }
        float f3 = fArray.length / 2;
        int n2 = Math.min((int)f3, fArray.length - n);
        if (this.dataBuffer == null || this.dataBuffer.length != n2 * 4) {
            this.dataBuffer = new float[n2 * 4];
        }
        int n3 = 0;
        for (int i = 0; i < n2 - 1; ++i) {
            float f4 = (float)i / f3;
            float f5 = (float)i / f3;
            this.dataBuffer[n3] = f4;
            this.dataBuffer[n3 + 1] = fArray[i + n];
            this.dataBuffer[n3 + 2] = f5;
            this.dataBuffer[n3 + 3] = fArray[i + 1 + n];
            n3 += 4;
        }
        this.handler.handleEvent(this.dataBuffer, audioEvent);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static interface OscilloscopeEventHandler {
        public void handleEvent(float[] var1, AudioEvent var2);
    }
}

