/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.fft.FFT;

public class PitchShifter
implements AudioProcessor {
    private final FFT fft;
    private final int size;
    private final float[] currentMagnitudes;
    private final float[] currentPhase;
    private final float[] currentFrequencies;
    private final float[] outputAccumulator;
    private final float[] summedPhase;
    private float[] previousPhase;
    private double pitchShiftRatio = 0.0;
    private final double sampleRate;
    private long osamp;
    private double excpt;

    public PitchShifter(double d, double d2, int n, int n2) {
        this.pitchShiftRatio = d;
        this.size = n;
        this.sampleRate = d2;
        this.osamp = n / (n - n2);
        this.excpt = Math.PI * 2 * (double)(n - n2) / (double)n;
        this.fft = new FFT(n);
        this.currentMagnitudes = new float[n / 2];
        this.currentFrequencies = new float[n / 2];
        this.currentPhase = new float[n / 2];
        this.previousPhase = new float[n / 2];
        this.summedPhase = new float[n / 2];
        this.outputAccumulator = new float[n * 2];
    }

    public void setPitchShiftFactor(float f) {
        this.pitchShiftRatio = f;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int n;
        float[] fArray = (float[])audioEvent.getFloatBuffer().clone();
        for (int i = 0; i < this.size; ++i) {
            float f = (float)(-0.5 * Math.cos(Math.PI * 2 * (double)i / (double)this.size) + 0.5);
            fArray[i] = f * fArray[i];
        }
        this.fft.forwardTransform(fArray);
        this.fft.powerAndPhaseFromFFT(fArray, this.currentMagnitudes, this.currentPhase);
        float f = (float)(this.sampleRate / (double)this.size);
        for (int i = 0; i < this.size / 2; ++i) {
            float f2 = this.currentPhase[i];
            double d = f2 - this.previousPhase[i];
            this.previousPhase[i] = f2;
            long l = (long)((d -= (double)i * this.excpt) / Math.PI);
            l = l >= 0L ? (l += l & 1L) : (l -= l & 1L);
            d -= Math.PI * (double)l;
            d = (double)this.osamp * d / (Math.PI * 2);
            d = (double)i * (double)f + d * (double)f;
            this.currentFrequencies[i] = (float)d;
        }
        float[] fArray2 = new float[this.size / 2];
        float[] fArray3 = new float[this.size / 2];
        for (int i = 0; i < this.size / 2; ++i) {
            n = (int)((double)i * this.pitchShiftRatio);
            if (n >= this.size / 2) continue;
            int n2 = n;
            fArray2[n2] = fArray2[n2] + this.currentMagnitudes[i];
            fArray3[n] = (float)((double)this.currentFrequencies[i] * this.pitchShiftRatio);
        }
        float[] fArray4 = new float[this.size];
        for (n = 0; n < this.size / 2; ++n) {
            float f3 = fArray2[n];
            double d = fArray3[n];
            d -= (double)n * (double)f;
            d /= (double)f;
            d = Math.PI * 2 * d / (double)this.osamp;
            int n3 = n;
            this.summedPhase[n3] = (float)((double)this.summedPhase[n3] + (d += (double)n * this.excpt));
            float f4 = this.summedPhase[n];
            fArray4[2 * n] = (float)((double)f3 * Math.cos(f4));
            fArray4[2 * n + 1] = (float)((double)f3 * Math.sin(f4));
        }
        for (n = this.size / 2 + 2; n < this.size; ++n) {
            fArray4[n] = 0.0f;
        }
        this.fft.backwardsTransform(fArray4);
        for (n = 0; n < fArray4.length; ++n) {
            float f5 = (float)(-0.5 * Math.cos(Math.PI * 2 * (double)n / (double)this.size) + 0.5);
            int n4 = n;
            this.outputAccumulator[n4] = this.outputAccumulator[n4] + f5 * fArray4[n] / (float)this.osamp;
            if (!((double)this.outputAccumulator[n] > 1.0) && !((double)this.outputAccumulator[n] < -1.0)) continue;
            System.err.println("Clipping!");
        }
        n = (int)((long)this.size / this.osamp);
        System.arraycopy(this.outputAccumulator, n, this.outputAccumulator, 0, this.size);
        float[] fArray5 = new float[audioEvent.getFloatBuffer().length];
        audioEvent.setFloatBuffer(fArray5);
        System.arraycopy(this.outputAccumulator, 0, fArray5, this.size - n, n);
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

