/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class SilenceDetector
implements AudioProcessor {
    public static final double DEFAULT_SILENCE_THRESHOLD = -70.0;
    private final double threshold;
    private final boolean breakProcessingQueueOnSilence;
    double currentSPL = 0.0;

    public SilenceDetector() {
        this(-70.0, false);
    }

    public SilenceDetector(double d, boolean bl) {
        this.threshold = d;
        this.breakProcessingQueueOnSilence = bl;
    }

    private double localEnergy(float[] fArray) {
        double d = 0.0;
        for (float f : fArray) {
            d += (double)(f * f);
        }
        return d;
    }

    private double soundPressureLevel(float[] fArray) {
        double d = Math.pow(this.localEnergy(fArray), 0.5);
        return this.linearToDecibel(d /= (double)fArray.length);
    }

    private double linearToDecibel(double d) {
        return 20.0 * Math.log10(d);
    }

    public double currentSPL() {
        return this.currentSPL;
    }

    public boolean isSilence(float[] fArray, double d) {
        this.currentSPL = this.soundPressureLevel(fArray);
        return this.currentSPL < d;
    }

    public boolean isSilence(float[] fArray) {
        return this.isSilence(fArray, this.threshold);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        boolean bl = this.isSilence(audioEvent.getFloatBuffer());
        if (this.breakProcessingQueueOnSilence) {
            return !bl;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

