/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.PitchConverter;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HammingWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SpectralPeakProcessor
implements AudioProcessor {
    private final int sampleRate;
    private final double dt;
    private final double cbin;
    private final double inv_2pi;
    private final double inv_deltat;
    private final double inv_2pideltat;
    private final FFT fft;
    private final float[] currentPhaseOffsets;
    private final float[] magnitudes;
    private final float[] frequencyEstimates;
    private float[] previousPhaseOffsets;

    public SpectralPeakProcessor(int n, int n2, int n3) {
        this.fft = new FFT(n, new HammingWindow());
        this.magnitudes = new float[n / 2];
        this.currentPhaseOffsets = new float[n / 2];
        this.frequencyEstimates = new float[n / 2];
        this.dt = (double)(n - n2) / (double)n3;
        this.cbin = this.dt * (double)n3 / (double)n;
        this.inv_2pi = 0.15915494309189535;
        this.inv_deltat = 1.0 / this.dt;
        this.inv_2pideltat = this.inv_deltat * this.inv_2pi;
        this.sampleRate = n3;
    }

    private void calculateFFT(float[] fArray) {
        float[] fArray2 = (float[])fArray.clone();
        this.fft.powerPhaseFFT(fArray2, this.magnitudes, this.currentPhaseOffsets);
    }

    private void normalizeMagintudes() {
        int n;
        float f = -1000000.0f;
        for (n = 0; n < this.magnitudes.length; ++n) {
            f = Math.max(f, this.magnitudes[n]);
        }
        for (n = 1; n < this.magnitudes.length; ++n) {
            this.magnitudes[n] = (float)(10.0 * Math.log10(this.magnitudes[n] / f)) + 75.0f;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        this.calculateFFT(fArray);
        this.calculateFrequencyEstimates();
        this.normalizeMagintudes();
        this.previousPhaseOffsets = (float[])this.currentPhaseOffsets.clone();
        return true;
    }

    @Override
    public void processingFinished() {
    }

    private void calculateFrequencyEstimates() {
        for (int i = 0; i < this.frequencyEstimates.length; ++i) {
            this.frequencyEstimates[i] = this.getFrequencyForBin(i);
        }
    }

    public float[] getMagnitudes() {
        return (float[])this.magnitudes.clone();
    }

    public float[] getFrequencyEstimates() {
        return (float[])this.frequencyEstimates.clone();
    }

    private float getFrequencyForBin(int n) {
        float f;
        if (this.previousPhaseOffsets != null) {
            float f2 = this.currentPhaseOffsets[n] - this.previousPhaseOffsets[n];
            long l = Math.round(this.cbin * (double)n - this.inv_2pi * (double)f2);
            f = (float)(this.inv_2pideltat * (double)f2 + this.inv_deltat * (double)l);
        } else {
            f = (float)this.fft.binToHz(n, this.sampleRate);
        }
        return f;
    }

    public static float[] calculateNoiseFloor(float[] fArray, int n, float f) {
        int n2;
        float[] fArray2 = new float[fArray.length];
        float f2 = (float)SpectralPeakProcessor.median((float[])fArray.clone());
        for (int i = 0; i < fArray.length; ++i) {
            double[] dArray = new double[n];
            n2 = 0;
            for (int j = i - n / 2; j <= i + n / 2 && n2 < dArray.length; ++n2, ++j) {
                dArray[n2] = j >= 0 && j < fArray.length ? (double)fArray[j] : (double)f2;
            }
            fArray2[i] = SpectralPeakProcessor.median(dArray) * f;
        }
        float f3 = 12.0f;
        n2 = 0;
        while ((float)n2 <= f3) {
            float f4 = 1.0f;
            f4 = (float)(-1.0 * Math.log((float)n2 / f3)) + 1.0f;
            fArray2[n2] = f4 * fArray2[n2];
            ++n2;
        }
        return fArray2;
    }

    public static List<Integer> findLocalMaxima(float[] fArray, float[] fArray2) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i < fArray.length - 1; ++i) {
            boolean bl;
            boolean bl2 = fArray[i - 1] < fArray[i];
            boolean bl3 = fArray[i] > fArray[i + 1];
            boolean bl4 = bl = fArray[i] > fArray2[i];
            if (!bl2 || !bl3 || !bl) continue;
            arrayList.add(i);
        }
        return arrayList;
    }

    private static int findMaxMagnitudeIndex(float[] fArray) {
        int n = 0;
        float f = -1000000.0f;
        for (int i = 1; i < fArray.length - 1; ++i) {
            if (!(fArray[i] > f)) continue;
            f = fArray[i];
            n = i;
        }
        return n;
    }

    public static List<SpectralPeak> findPeaks(float[] fArray, float[] fArray2, List<Integer> list, int n, int n2) {
        int n3;
        int n4 = SpectralPeakProcessor.findMaxMagnitudeIndex(fArray);
        ArrayList<SpectralPeak> arrayList = new ArrayList<SpectralPeak>();
        if (list.size() == 0) {
            return arrayList;
        }
        float f = 0.0f;
        f = fArray2[n4];
        for (n3 = 0; n3 < list.size(); ++n3) {
            if (!(fArray2[list.get(n3)] < 0.0f)) continue;
            list.remove(n3);
            fArray2[list.get((int)n3).intValue()] = 1.0f;
            --n3;
        }
        for (n3 = 1; n3 < list.size(); ++n3) {
            double d;
            double d2 = PitchConverter.hertzToAbsoluteCent(fArray2[list.get(n3)]);
            double d3 = d2 - (d = PitchConverter.hertzToAbsoluteCent(fArray2[list.get(n3 - 1)]));
            if (!(d3 < (double)n2)) continue;
            if (fArray[list.get(n3)] > fArray[list.get(n3 - 1)]) {
                list.remove(n3 - 1);
            } else {
                list.remove(n3);
            }
            --n3;
        }
        float[] fArray3 = new float[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            fArray3[i] = fArray[list.get(i)];
        }
        Arrays.sort(fArray3);
        float f2 = fArray3[0];
        if (fArray3.length > n) {
            f2 = fArray3[fArray3.length - n];
        }
        for (Integer n5 : list) {
            if (!(fArray[n5] >= f2)) continue;
            float f3 = fArray2[n5];
            float f4 = fArray[n5];
            SpectralPeak spectralPeak = new SpectralPeak(0.0f, f3, f4, f, n5);
            arrayList.add(spectralPeak);
        }
        return arrayList;
    }

    public static final float median(double[] dArray) {
        return SpectralPeakProcessor.percentile(dArray, 0.5);
    }

    public static final float percentile(double[] dArray, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Percentile out of range.");
        }
        Arrays.sort(dArray);
        double d2 = d * (double)(dArray.length - 1);
        int n = (int)d2;
        return (float)(((double)(n + 1) - d2) * dArray[n] + (d2 - (double)n) * dArray[n + 1]);
    }

    public static double median(float[] fArray) {
        Arrays.sort(fArray);
        int n = fArray.length / 2;
        if (fArray.length % 2 == 1) {
            return fArray[n];
        }
        return (double)(fArray[n - 1] + fArray[n]) / 2.0;
    }

    public static class SpectralPeak {
        private final float frequencyInHertz;
        private final float magnitude;
        private final float referenceFrequency;
        private final int bin;
        private final float timeStamp;

        public SpectralPeak(float f, float f2, float f3, float f4, int n) {
            this.frequencyInHertz = f2;
            this.magnitude = f3;
            this.referenceFrequency = f4;
            this.timeStamp = f;
            this.bin = n;
        }

        public float getRelativeFrequencyInCents() {
            if (this.referenceFrequency > 0.0f && this.frequencyInHertz > 0.0f) {
                float f = (float)PitchConverter.hertzToAbsoluteCent(this.referenceFrequency);
                float f2 = (float)PitchConverter.hertzToAbsoluteCent(this.frequencyInHertz);
                return f2 - f;
            }
            return 0.0f;
        }

        public float getTimeStamp() {
            return this.timeStamp;
        }

        public float getMagnitude() {
            return this.magnitude;
        }

        public float getFrequencyInHertz() {
            return this.frequencyInHertz;
        }

        public float getRefFrequencyInHertz() {
            return this.referenceFrequency;
        }

        public String toString() {
            return String.format("%.2f %.2f %.2f", Float.valueOf(this.frequencyInHertz), Float.valueOf(this.getRelativeFrequencyInCents()), Float.valueOf(this.magnitude));
        }

        public int getBin() {
            return this.bin;
        }
    }
}

