/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class WaveformSimilarityBasedOverlapAdd
implements AudioProcessor {
    private int seekWindowLength;
    private int seekLength;
    private int overlapLength;
    private float[] pMidBuffer;
    private float[] pRefMidBuffer;
    private float[] outputFloatBuffer;
    private int intskip;
    private int sampleReq;
    private double tempo;
    private AudioDispatcher dispatcher;
    private Parameters newParameters;

    public WaveformSimilarityBasedOverlapAdd(Parameters parameters) {
        this.setParameters(parameters);
        this.applyNewParameters();
    }

    public void setParameters(Parameters parameters) {
        this.newParameters = parameters;
    }

    public void setDispatcher(AudioDispatcher audioDispatcher) {
        this.dispatcher = audioDispatcher;
    }

    private void applyNewParameters() {
        Parameters parameters = this.newParameters;
        int n = this.overlapLength;
        this.overlapLength = (int)(parameters.getSampleRate() * parameters.getOverlapMs() / 1000.0);
        this.seekWindowLength = (int)(parameters.getSampleRate() * parameters.getSequenceMs() / 1000.0);
        this.seekLength = (int)(parameters.getSampleRate() * parameters.getSeekWindowMs() / 1000.0);
        this.tempo = parameters.getTempo();
        if (this.overlapLength > n * 8 && this.pMidBuffer == null) {
            this.pMidBuffer = new float[this.overlapLength * 8];
            this.pRefMidBuffer = new float[this.overlapLength * 8];
            System.out.println("New overlapLength" + this.overlapLength);
        }
        double d = this.tempo * (double)(this.seekWindowLength - this.overlapLength);
        this.intskip = (int)(d + 0.5);
        this.sampleReq = Math.max(this.intskip + this.overlapLength, this.seekWindowLength) + this.seekLength;
        float[] fArray = this.outputFloatBuffer;
        this.outputFloatBuffer = new float[this.getOutputBufferSize()];
        if (fArray != null) {
            System.out.println("Copy outputFloatBuffer contents");
            for (int i = 0; i < fArray.length && i < this.outputFloatBuffer.length; ++i) {
                this.outputFloatBuffer[i] = fArray[i];
            }
        }
        this.newParameters = null;
    }

    public int getInputBufferSize() {
        return this.sampleReq;
    }

    private int getOutputBufferSize() {
        return this.seekWindowLength - this.overlapLength;
    }

    public int getOverlap() {
        return this.sampleReq - this.intskip;
    }

    private void overlap(float[] fArray, int n, float[] fArray2, int n2) {
        for (int i = 0; i < this.overlapLength; ++i) {
            int n3 = this.overlapLength - i;
            fArray[i + n] = (fArray2[i + n2] * (float)i + this.pMidBuffer[i] * (float)n3) / (float)this.overlapLength;
        }
    }

    private int seekBestOverlapPosition(float[] fArray, int n) {
        this.precalcCorrReferenceMono();
        double d = -10.0;
        int n2 = 0;
        for (int i = 0; i < this.seekLength; ++i) {
            int n3 = n + i;
            double d2 = this.calcCrossCorr(this.pRefMidBuffer, fArray, n3);
            double d3 = (double)(2 * i - this.seekLength) / (double)this.seekLength;
            if (!((d2 = (d2 + 0.1) * (1.0 - 0.25 * d3 * d3)) > d)) continue;
            d = d2;
            n2 = i;
        }
        return n2;
    }

    void precalcCorrReferenceMono() {
        for (int i = 0; i < this.overlapLength; ++i) {
            float f = i * (this.overlapLength - i);
            this.pRefMidBuffer[i] = this.pMidBuffer[i] * f;
        }
    }

    double calcCrossCorr(float[] fArray, float[] fArray2, int n) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 1; i < this.overlapLength; ++i) {
            d += (double)(fArray[i] * fArray2[i + n]);
            d2 += (double)(fArray[i] * fArray[i]);
        }
        if (d2 < 1.0E-8) {
            d2 = 1.0;
        }
        return d / Math.pow(d2, 0.5);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        assert (fArray.length == this.getInputBufferSize());
        int n = this.seekBestOverlapPosition(fArray, 0);
        this.overlap(this.outputFloatBuffer, 0, fArray, n);
        int n2 = this.seekWindowLength - 2 * this.overlapLength;
        System.arraycopy(fArray, n + this.overlapLength, this.outputFloatBuffer, this.overlapLength, n2);
        System.arraycopy(fArray, n + n2 + this.overlapLength, this.pMidBuffer, 0, this.overlapLength);
        assert (this.outputFloatBuffer.length == this.getOutputBufferSize());
        audioEvent.setFloatBuffer(this.outputFloatBuffer);
        audioEvent.setOverlap(0);
        if (this.newParameters != null) {
            this.applyNewParameters();
            this.dispatcher.setStepSizeAndOverlap(this.getInputBufferSize(), this.getOverlap());
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public static class Parameters {
        private final int sequenceMs;
        private final int seekWindowMs;
        private final int overlapMs;
        private final double tempo;
        private final double sampleRate;

        public Parameters(double d, double d2, int n, int n2, int n3) {
            this.tempo = d;
            this.sampleRate = d2;
            this.overlapMs = n3;
            this.seekWindowMs = n2;
            this.sequenceMs = n;
        }

        public static Parameters speechDefaults(double d, double d2) {
            int n = 40;
            int n2 = 15;
            int n3 = 12;
            return new Parameters(d, d2, n, n2, n3);
        }

        public static Parameters musicDefaults(double d, double d2) {
            int n = 82;
            int n2 = 28;
            int n3 = 12;
            return new Parameters(d, d2, n, n2, n3);
        }

        public static Parameters slowdownDefaults(double d, double d2) {
            int n = 100;
            int n2 = 35;
            int n3 = 20;
            return new Parameters(d, d2, n, n2, n3);
        }

        public static Parameters automaticDefaults(double d, double d2) {
            double d3 = 0.5;
            double d4 = 2.0;
            double d5 = 125.0;
            double d6 = 50.0;
            double d7 = (d6 - d5) / (d4 - d3);
            double d8 = d5 - d7 * d3;
            double d9 = 25.0;
            double d10 = 15.0;
            double d11 = (d10 - d9) / (d4 - d3);
            double d12 = d9 - d11 * d9;
            int n = (int)(d8 + d7 * d + 0.5);
            int n2 = (int)(d12 + d11 * d + 0.5);
            int n3 = 12;
            return new Parameters(d, d2, n, n2, n3);
        }

        public double getOverlapMs() {
            return this.overlapMs;
        }

        public double getSequenceMs() {
            return this.sequenceMs;
        }

        public double getSeekWindowMs() {
            return this.seekWindowMs;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }

        public double getTempo() {
            return this.tempo;
        }
    }
}

