/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.AgentList;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import be.tarsos.dsp.beatroot.Induction;
import java.util.ListIterator;

public class Agent {
    public static boolean debug = false;
    public static double POST_MARGIN_FACTOR = 0.3;
    public static double PRE_MARGIN_FACTOR = 0.15;
    public static final double INNER_MARGIN = 0.04;
    public static double MAX_CHANGE = 0.2;
    public static double CONF_FACTOR = 0.5;
    public static final double DEFAULT_CORRECTION_FACTOR = 50.0;
    public static final double DEFAULT_EXPIRY_TIME = 10.0;
    protected static int idCounter = 0;
    protected static double innerMargin;
    protected static double correctionFactor;
    protected static double expiryTime;
    protected static double decayFactor;
    public double preMargin;
    public double postMargin;
    protected int idNumber;
    public double tempoScore;
    public double phaseScore;
    public double topScoreTime;
    public int beatCount;
    public double beatInterval;
    public double initialBeatInterval;
    public double beatTime;
    public EventList events;

    public Agent(double d) {
        this.init(d);
    }

    public Agent(Agent agent) {
        this.idNumber = idCounter++;
        this.phaseScore = agent.phaseScore;
        this.tempoScore = agent.tempoScore;
        this.topScoreTime = agent.topScoreTime;
        this.beatCount = agent.beatCount;
        this.beatInterval = agent.beatInterval;
        this.initialBeatInterval = agent.initialBeatInterval;
        this.beatTime = agent.beatTime;
        this.events = new EventList(agent.events);
        this.postMargin = agent.postMargin;
        this.preMargin = agent.preMargin;
    }

    protected void init(double d) {
        innerMargin = 0.04;
        correctionFactor = 50.0;
        expiryTime = 10.0;
        decayFactor = 0.0;
        this.beatInterval = d;
        this.initialBeatInterval = d;
        this.postMargin = d * POST_MARGIN_FACTOR;
        this.preMargin = d * PRE_MARGIN_FACTOR;
        this.idNumber = idCounter++;
        this.phaseScore = 0.0;
        this.tempoScore = 0.0;
        this.topScoreTime = 0.0;
        this.beatCount = 0;
        this.beatTime = -1.0;
        this.events = new EventList();
    }

    public void print() {
        this.print(100);
    }

    public void print(int n) {
        System.out.printf("\tAg#%4d: %5.3f", this.idNumber, this.beatInterval);
        if (n >= 1) {
            System.out.printf("  Beat#%3d  Time=%7.3f  Score=%4.2f:P%4.2f:%3.1f", this.beatCount, this.beatTime, this.tempoScore, this.phaseScore, this.topScoreTime);
        }
        if (n >= 2) {
            System.out.println();
        }
        if (n >= 3) {
            this.events.print();
        }
    }

    protected void accept(Event event, double d, int n) {
        this.beatTime = event.keyDown;
        this.events.add(event);
        if (Math.abs(this.initialBeatInterval - this.beatInterval - d / correctionFactor) < MAX_CHANGE * this.initialBeatInterval) {
            this.beatInterval += d / correctionFactor;
        }
        this.beatCount += n;
        double d2 = 1.0 - CONF_FACTOR * d / (d > 0.0 ? this.postMargin : -this.preMargin);
        if (decayFactor > 0.0) {
            double d3 = 1.0 - 1.0 / this.threshold(this.beatCount, 1.0, decayFactor);
            this.phaseScore = d3 * this.phaseScore + (1.0 - d3) * d2 * event.salience;
        } else {
            this.phaseScore += d2 * event.salience;
        }
        if (debug) {
            this.print(1);
            System.out.printf("  Err=" + (d < 0.0 ? "" : "+") + "%5.3f" + (Math.abs(d) > innerMargin ? (char)'*' : ' ') + "%5.3f\n", d, d2);
        }
    }

    private double threshold(double d, double d2, double d3) {
        if (d < d2) {
            return d2;
        }
        if (d > d3) {
            return d3;
        }
        return d;
    }

    public boolean considerAsBeat(Event event, AgentList agentList) {
        if (this.beatTime < 0.0) {
            this.accept(event, 0.0, 1);
            return true;
        }
        if (event.keyDown - this.events.l.getLast().keyDown > expiryTime) {
            this.phaseScore = -1.0;
            return false;
        }
        double d = Math.round((event.keyDown - this.beatTime) / this.beatInterval);
        double d2 = event.keyDown - this.beatTime - d * this.beatInterval;
        if (d > 0.0 && -this.preMargin <= d2 && d2 <= this.postMargin) {
            if (Math.abs(d2) > innerMargin) {
                agentList.add(new Agent(this));
            }
            this.accept(event, d2, (int)d);
            return true;
        }
        return false;
    }

    protected void fillBeats() {
        this.fillBeats(-1.0);
    }

    public void fillBeats(double d) {
        double d2 = 0.0;
        ListIterator<Event> listIterator = this.events.listIterator();
        if (listIterator.hasNext()) {
            d2 = listIterator.next().keyDown;
            listIterator.previous();
        }
        while (listIterator.hasNext()) {
            double d3;
            double d4 = listIterator.next().keyDown;
            listIterator.previous();
            double d5 = (d4 - d2) / d3;
            for (d3 = (double)Math.round((d4 - d2) / this.beatInterval - 0.01); d4 > d && d3 > 1.5; d3 -= 1.0) {
                d2 += d5;
                if (debug) {
                    System.out.printf("Insert beat at: %8.3f (n=%1.0f)\n", d2, d3 - 1.0);
                }
                listIterator.add(this.newBeat(d2, 0));
            }
            d2 = d4;
            listIterator.next();
        }
    }

    private Event newBeat(double d, int n) {
        return new Event(d, d, d, 56, 64, n, 0.0, 1);
    }

    public void showTracking(EventList eventList) {
        this.showTracking(eventList, 1.0);
    }

    public void showTracking(EventList eventList, double d) {
        int n = 1;
        ListIterator<Event> listIterator = this.events.listIterator();
        ListIterator<Event> listIterator2 = eventList.listIterator();
        if (!listIterator.hasNext()) {
            System.err.println("No beats found");
            return;
        }
        double d2 = this.events.l.getFirst().keyDown;
        System.out.print("Beat  (IBI)   BeatTime   Other Events");
        boolean bl = true;
        while (listIterator2.hasNext()) {
            double d3;
            int n2;
            int n3;
            double d4;
            Event event = listIterator2.next();
            Event event2 = null;
            while (listIterator.hasNext()) {
                event2 = listIterator.next();
                if (event2.keyDown > event.keyDown + Induction.clusterWidth) break;
                d4 = event2.keyDown - d2;
                n3 = (int)Math.round(d4 / this.beatInterval);
                for (n2 = 1; n2 < n3; ++n2) {
                    d3 = d2 + d4 / (double)n3;
                    System.out.printf("\n%4d (%5.3f) [%7.3f ]", n++, d3 - d2, d3);
                    d2 = d3;
                }
                System.out.printf("\n%4d (%5.3f) ", n++, event.keyDown - d2);
                d2 = event2.keyDown;
                event2 = null;
                bl = false;
            }
            if (event2 != null && event2.keyDown > event.keyDown) {
                d4 = event2.keyDown - d2;
                n3 = (int)Math.round(d4 / this.beatInterval);
                for (n2 = 1; n2 < n3 && !((d3 = d2 + d4 / (double)n3) >= event.keyDown); ++n2) {
                    System.out.printf("\n%4d (%5.3f) [%7.3f ]", n++, d3 - d2, d3);
                    d2 = d3;
                }
                bl = false;
            }
            if (bl) {
                System.out.print("\n                       ");
            }
            System.out.printf("%8.3f%c ", event.keyDown, Character.valueOf(Math.abs(event.scoreBeat / d - (double)Math.round(event.scoreBeat / d)) < 0.001 ? (char)'*' : ' '));
            bl = false;
        }
        System.out.println();
    }
}

