/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Agent;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import java.util.ListIterator;

public class AgentList {
    public static boolean useAverageSalience = false;
    public static boolean debug = false;
    public static final double DEFAULT_BI = 0.02;
    public static final double DEFAULT_BT = 0.04;
    public Agent ag;
    public AgentList next;
    public static int count = 0;
    public static double thresholdBI = 0.02;
    public static double thresholdBT = 0.04;

    public AgentList() {
        this(null, null);
    }

    public AgentList(Agent agent, AgentList agentList) {
        this.ag = agent;
        this.next = agentList;
        if (this.next == null) {
            if (this.ag != null) {
                this.next = new AgentList();
            } else {
                count = 0;
                thresholdBI = 0.02;
                thresholdBT = 0.04;
            }
        }
    }

    public void print() {
        System.out.println("agentList.print: (size=" + count + ")");
        AgentList agentList = this;
        while (agentList.ag != null) {
            agentList.ag.print(2);
            agentList = agentList.next;
        }
        System.out.println("End of agentList.print()");
    }

    public void add(Agent agent) {
        this.add(agent, true);
    }

    public void add(Agent agent, boolean bl) {
        if (agent == null) {
            return;
        }
        ++count;
        AgentList agentList = this;
        while (agentList.ag != null) {
            if (bl && agent.beatInterval <= agentList.ag.beatInterval) {
                agentList.next = new AgentList(agentList.ag, agentList.next);
                agentList.ag = agent;
                return;
            }
            agentList = agentList.next;
        }
        agentList.next = new AgentList();
        agentList.ag = agent;
    }

    public void sort() {
        boolean bl = false;
        while (!bl) {
            bl = true;
            AgentList agentList = this;
            while (agentList.ag != null) {
                if (agentList.next.ag != null && agentList.ag.beatInterval > agentList.next.ag.beatInterval) {
                    Agent agent = agentList.ag;
                    agentList.ag = agentList.next.ag;
                    agentList.next.ag = agent;
                    bl = false;
                }
                agentList = agentList.next;
            }
        }
    }

    public void remove(AgentList agentList) {
        --count;
        agentList.ag = agentList.next.ag;
        agentList.next = agentList.next.next;
    }

    protected void removeDuplicates() {
        this.sort();
        AgentList agentList = this;
        while (agentList.ag != null) {
            if (!(agentList.ag.phaseScore < 0.0)) {
                AgentList agentList2 = agentList.next;
                while (agentList2.ag != null && !(agentList2.ag.beatInterval - agentList.ag.beatInterval > thresholdBI)) {
                    if (!(Math.abs(agentList.ag.beatTime - agentList2.ag.beatTime) > thresholdBT)) {
                        if (agentList.ag.phaseScore < agentList2.ag.phaseScore) {
                            agentList.ag.phaseScore = -1.0;
                            if (!(agentList2.ag.topScoreTime < agentList.ag.topScoreTime)) break;
                            agentList2.ag.topScoreTime = agentList.ag.topScoreTime;
                            break;
                        }
                        agentList2.ag.phaseScore = -1.0;
                        if (agentList.ag.topScoreTime < agentList2.ag.topScoreTime) {
                            agentList.ag.topScoreTime = agentList2.ag.topScoreTime;
                        }
                    }
                    agentList2 = agentList2.next;
                }
            }
            agentList = agentList.next;
        }
        agentList = this;
        while (agentList.ag != null) {
            if (agentList.ag.phaseScore < 0.0) {
                this.remove(agentList);
                continue;
            }
            agentList = agentList.next;
        }
    }

    public void beatTrack(EventList eventList) {
        this.beatTrack(eventList, -1.0);
    }

    public void beatTrack(EventList eventList, double d) {
        boolean bl;
        ListIterator<Event> listIterator = eventList.listIterator();
        boolean bl2 = bl = this.ag != null && this.ag.beatTime >= 0.0;
        while (listIterator.hasNext()) {
            Event event = listIterator.next();
            if (d > 0.0 && event.keyDown > d) break;
            boolean bl3 = bl;
            double d2 = -1.0;
            AgentList agentList = this;
            while (agentList.ag != null) {
                Agent agent = agentList.ag;
                if (agent.beatInterval != d2) {
                    if (d2 >= 0.0 && !bl3 && event.keyDown < 5.0) {
                        Agent agent2 = new Agent(d2);
                        agent2.considerAsBeat(event, this);
                        this.add(agent2);
                    }
                    d2 = agent.beatInterval;
                    bl3 = bl;
                }
                if (agent.considerAsBeat(event, this)) {
                    bl3 = true;
                }
                if (agent != agentList.ag) {
                    agentList = agentList.next;
                }
                agentList = agentList.next;
            }
            this.removeDuplicates();
        }
    }

    public Agent bestAgent() {
        double d = -1.0;
        Agent agent = null;
        AgentList agentList = this;
        while (agentList.ag != null) {
            double d2 = agentList.ag.events.l.getFirst().keyDown;
            double d3 = (agentList.ag.phaseScore + agentList.ag.tempoScore) / (useAverageSalience ? (double)agentList.ag.beatCount : 1.0);
            if (d3 > d) {
                agent = agentList.ag;
                d = d3;
            }
            if (debug) {
                agentList.ag.print(0);
                System.out.printf(" +%5.3f    Av-salience = %3.1f\n", d2, d3);
            }
            agentList = agentList.next;
        }
        if (debug) {
            if (agent != null) {
                System.out.print("Best ");
                agent.print(0);
                System.out.printf("    Av-salience = %5.1f\n", d);
            } else {
                System.out.println("No surviving agent - beat tracking failed");
            }
        }
        return agent;
    }
}

