/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Agent;
import be.tarsos.dsp.beatroot.AgentList;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import be.tarsos.dsp.beatroot.Induction;
import be.tarsos.dsp.onsets.OnsetHandler;
import java.util.Iterator;

public class BeatRootOnsetEventHandler
implements OnsetHandler {
    private final EventList onsetList = new EventList();

    @Override
    public void handleOnset(double d, double d2) {
        double d3 = (double)Math.round(d * 100.0) / 100.0;
        Event event = this.newEvent(d3, 0);
        event.salience = d2;
        this.onsetList.add(event);
    }

    private Event newEvent(double d, int n) {
        return new Event(d, d, d, 56, 64, n, 0.0, 1);
    }

    public void trackBeats(OnsetHandler onsetHandler) {
        AgentList agentList = null;
        agentList = Induction.beatInduction(this.onsetList);
        agentList.beatTrack(this.onsetList, -1.0);
        Agent agent = agentList.bestAgent();
        if (agent != null) {
            agent.fillBeats(-1.0);
            EventList eventList = agent.events;
            Iterator<Event> iterator = eventList.iterator();
            while (iterator.hasNext()) {
                Event event = iterator.next();
                double d = event.keyDown;
                onsetHandler.handleOnset(d, -1.0);
            }
        } else {
            System.err.println("No best agent");
        }
    }
}

