/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Flags;

public class Event
implements Comparable<Event>,
Cloneable {
    public double keyDown;
    public double keyUp;
    public double pedalUp;
    public double scoreBeat;
    public double scoreDuration;
    public double salience;
    public int midiPitch;
    public int midiVelocity;
    public int flags;
    public int midiCommand;
    public int midiChannel;
    public int midiTrack;

    public Event(double d, double d2, double d3, int n, int n2, double d4, double d5, int n3, int n4, int n5, int n6) {
        this(d, d2, d3, n, n2, d4, d5, n3);
        this.midiCommand = n4;
        this.midiChannel = n5;
        this.midiTrack = n6;
    }

    public Event(double d, double d2, double d3, int n, int n2, double d4, double d5, int n3) {
        this.keyDown = d;
        this.keyUp = d2;
        this.pedalUp = d3;
        this.midiPitch = n;
        this.midiVelocity = n2;
        this.scoreBeat = d4;
        this.scoreDuration = d5;
        this.flags = n3;
        this.midiCommand = 144;
        this.midiChannel = 1;
        this.midiTrack = 0;
        this.salience = 0.0;
    }

    public Event clone() {
        return new Event(this.keyDown, this.keyUp, this.pedalUp, this.midiPitch, this.midiVelocity, this.scoreBeat, this.scoreDuration, this.flags, this.midiCommand, this.midiChannel, this.midiTrack);
    }

    @Override
    public int compareTo(Event event) {
        return (int)Math.signum(this.keyDown - event.keyDown);
    }

    public String toString() {
        return "n=" + this.midiPitch + " v=" + this.midiVelocity + " t=" + this.keyDown + " to " + this.keyUp + " (" + this.pedalUp + ")";
    }

    public void print(Flags flags) {
        System.out.printf("Event:\n", new Object[0]);
        System.out.printf("\tkeyDown / Up / pedalUp: %5.3f / %5.3f /  %5.3f\n", this.keyDown, this.keyUp, this.pedalUp);
        System.out.printf("\tmidiPitch: %d\n", this.midiPitch);
        System.out.printf("\tmidiVelocity: %d\n", this.midiVelocity);
        System.out.printf("\tmidiCommand: %02x\t", this.midiCommand | this.midiChannel);
        System.out.printf("\tmidiTrack: %d\n", this.midiTrack);
        System.out.printf("\tsalience: %5.3f\t", this.salience);
        System.out.printf("\tscoreBeat: %5.3f\t", this.scoreBeat);
        System.out.printf("\tscoreDuration: %5.3f\n", this.scoreDuration);
        System.out.printf("\tflags: %X", this.flags);
        if (flags != null) {
            int n = this.flags;
            int n2 = 0;
            while (n != 0) {
                if (n % 2 == 1) {
                    System.out.print(" " + flags.getLabel(n2));
                }
                n >>>= 1;
                ++n2;
            }
        }
        System.out.print("\n\n");
    }
}

