/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.Flags;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;

public class EventList {
    public LinkedList<Event> l = new LinkedList();
    protected static boolean timingCorrection = false;
    protected static double timingDisplacement = 0.0;
    protected static int clockUnits = 480;
    protected static int clockRate = 500000;
    protected static double metricalLevel = 0.0;
    public static final double UNKNOWN = Double.NaN;
    protected static boolean noMelody = false;
    protected static boolean onlyMelody = false;
    protected static Flags flags = new Flags();

    public EventList() {
    }

    public EventList(EventList eventList) {
        this();
        ListIterator<Event> listIterator = eventList.listIterator();
        while (listIterator.hasNext()) {
            this.add(listIterator.next());
        }
    }

    public EventList(Event[] eventArray) {
        this();
        for (int i = 0; i < eventArray.length; ++i) {
            this.add(eventArray[i]);
        }
    }

    public void add(Event event) {
        this.l.add(event);
    }

    public void add(EventList eventList) {
        this.l.addAll(eventList.l);
    }

    public void insert(Event event, boolean bl) {
        ListIterator<Event> listIterator = this.l.listIterator();
        while (listIterator.hasNext()) {
            int n = event.compareTo((Event)listIterator.next());
            if (n < 0) {
                listIterator.previous();
                break;
            }
            if (!bl || n != 0) continue;
            listIterator.remove();
            break;
        }
        listIterator.add(event);
    }

    public ListIterator<Event> listIterator() {
        return this.l.listIterator();
    }

    public Iterator<Event> iterator() {
        return this.l.iterator();
    }

    public int size() {
        return this.l.size();
    }

    public Event[] toArray() {
        return this.toArray(0);
    }

    public double[] toOnsetArray() {
        double[] dArray = new double[this.l.size()];
        int n = 0;
        Iterator iterator = this.l.iterator();
        while (iterator.hasNext()) {
            dArray[n] = ((Event)iterator.next()).keyDown;
            ++n;
        }
        return dArray;
    }

    public Event[] toArray(int n) {
        int n2 = 0;
        for (Event event : this.l) {
            if (n != 0 && event.midiCommand != n) continue;
            ++n2;
        }
        Event[] eventArray = new Event[n2];
        int n3 = 0;
        for (Event event : this.l) {
            if (n != 0 && event.midiCommand != n) continue;
            eventArray[n3++] = event;
        }
        return eventArray;
    }

    public void writeBinary(String string) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string));
            objectOutputStream.writeObject(this);
            objectOutputStream.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }

    public static EventList readBinary(String string) {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(string));
            EventList eventList = (EventList)objectInputStream.readObject();
            objectInputStream.close();
            return eventList;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            return null;
        }
    }

    public void print() {
        Iterator iterator = this.l.iterator();
        while (iterator.hasNext()) {
            ((Event)iterator.next()).print(flags);
        }
    }

    public static void setTimingCorrection(double d) {
        timingCorrection = d >= 0.0;
        timingDisplacement = d;
    }
}

