/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import be.tarsos.dsp.beatroot.Agent;
import be.tarsos.dsp.beatroot.AgentList;
import be.tarsos.dsp.beatroot.Event;
import be.tarsos.dsp.beatroot.EventList;
import java.util.ListIterator;

public class Induction {
    public static double clusterWidth = 0.025;
    public static double minIOI = 0.07;
    public static double maxIOI = 2.5;
    public static double minIBI = 0.3;
    public static double maxIBI = 1.0;
    public static int topN = 10;
    public static boolean debug = false;

    public static AgentList beatInduction(EventList eventList) {
        double d;
        int n;
        double d2;
        int n2;
        int n3;
        int n4;
        int n5 = 0;
        int[] nArray = new int[topN];
        int n6 = (int)Math.ceil((maxIOI - minIOI) / clusterWidth);
        double[] dArray = new double[n6];
        int[] nArray2 = new int[n6];
        int[] nArray3 = new int[n6];
        ListIterator<Event> listIterator = eventList.listIterator();
        block0: while (listIterator.hasNext()) {
            Event event = listIterator.next();
            ListIterator<Event> listIterator2 = eventList.listIterator();
            Event event2 = listIterator2.next();
            while (event2 != event) {
                event2 = listIterator2.next();
            }
            while (listIterator2.hasNext()) {
                event2 = listIterator2.next();
                double d3 = event2.keyDown - event.keyDown;
                if (d3 < minIOI) continue;
                if (d3 > maxIOI) continue block0;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!(Math.abs(dArray[n4] - d3) < clusterWidth)) continue;
                    if (n4 < n5 - 1 && Math.abs(dArray[n4 + 1] - d3) < Math.abs(dArray[n4] - d3)) {
                        ++n4;
                    }
                    dArray[n4] = (dArray[n4] * (double)nArray2[n4] + d3) / (double)(nArray2[n4] + 1);
                    int n7 = n4;
                    nArray2[n7] = nArray2[n7] + 1;
                    break;
                }
                if (n4 != n5) continue;
                if (n5 == n6) {
                    System.err.println("Warning: Too many clusters");
                    continue;
                }
                ++n5;
                while (n4 > 0 && dArray[n4 - 1] > d3) {
                    dArray[n4] = dArray[n4 - 1];
                    nArray2[n4] = nArray2[n4 - 1];
                    --n4;
                }
                dArray[n4] = d3;
                nArray2[n4] = 1;
            }
        }
        if (debug) {
            System.out.println("Inter-onset interval histogram:\nStartMatlabCode\nioi = [");
            for (n4 = 0; n4 < n5; ++n4) {
                System.out.printf("%4d %7.3f %7d\n", n4, dArray[n4], nArray2[n4]);
            }
            System.out.println("]; ioiclusters(ioi, name);\nEndMatlabCode\n");
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                if (!(Math.abs(dArray[n4] - dArray[n3]) < clusterWidth)) continue;
                dArray[n4] = (dArray[n4] * (double)nArray2[n4] + dArray[n3] * (double)nArray2[n3]) / (double)(nArray2[n4] + nArray2[n3]);
                nArray2[n4] = nArray2[n4] + nArray2[n3];
                --n5;
                for (n2 = n3 + 1; n2 <= n5; ++n2) {
                    dArray[n2 - 1] = dArray[n2];
                    nArray2[n2 - 1] = nArray2[n2];
                }
            }
        }
        if (n5 == 0) {
            return new AgentList();
        }
        for (n4 = 0; n4 < n5; ++n4) {
            nArray3[n4] = 10 * nArray2[n4];
        }
        nArray[0] = 0;
        int n8 = 1;
        block10: for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = 0; n3 <= n8; ++n3) {
                if (n3 >= topN || n3 != n8 && nArray3[n4] <= nArray3[nArray[n3]]) continue;
                if (n8 < topN) {
                    ++n8;
                }
                for (n2 = n8 - 1; n2 > n3; --n2) {
                    nArray[n2] = nArray[n2 - 1];
                }
                nArray[n3] = n4;
                continue block10;
            }
        }
        if (debug) {
            System.out.println("Best " + n8 + " clusters (before):");
            for (n4 = 0; n4 < n8; ++n4) {
                System.out.printf("%5.3f : %5d\n", dArray[nArray[n4]], nArray3[nArray[n4]]);
            }
        }
        for (n4 = 0; n4 < n5; ++n4) {
            for (n3 = n4 + 1; n3 < n5; ++n3) {
                d2 = dArray[n4] / dArray[n3];
                boolean bl = d2 < 1.0;
                n = bl ? (int)Math.round(1.0 / d2) : (int)Math.round(d2);
                if (n < 2 || n > 8) continue;
                d = bl ? Math.abs(dArray[n4] * (double)n - dArray[n3]) : Math.abs(dArray[n4] - dArray[n3] * (double)n);
                double d4 = bl ? clusterWidth : clusterWidth * (double)n;
                if (!(d < d4)) continue;
                n = n >= 5 ? 1 : 6 - n;
                int n9 = n4;
                nArray3[n9] = nArray3[n9] + n * nArray2[n3];
                int n10 = n3;
                nArray3[n10] = nArray3[n10] + n * nArray2[n4];
            }
        }
        if (debug) {
            System.out.println("Best " + n8 + " clusters (after):");
            for (n4 = 0; n4 < n8; ++n4) {
                System.out.printf("%5.3f : %5d\n", dArray[nArray[n4]], nArray3[nArray[n4]]);
            }
        }
        if (debug) {
            System.out.println("Inter-onset interval histogram 2:");
            for (n4 = 0; n4 < n5; ++n4) {
                System.out.printf("%3d: %5.3f : %3d (score: %5d)\n", n4, dArray[n4], nArray2[n4], nArray3[n4]);
            }
        }
        AgentList agentList = new AgentList();
        for (int i = 0; i < n8; ++i) {
            double d5;
            n4 = nArray[i];
            double d6 = dArray[n4] * (double)nArray3[n4];
            int n11 = nArray3[n4];
            for (n3 = 0; n3 < n5; ++n3) {
                if (n3 == n4) continue;
                d2 = dArray[n4] / dArray[n3];
                if (d2 < 1.0) {
                    n = (int)Math.round(1.0 / d2);
                    if (n < 2 || n > 8 || !((d = Math.abs(dArray[n4] * (double)n - dArray[n3])) < clusterWidth)) continue;
                    d6 += dArray[n3] / (double)n * (double)nArray3[n3];
                    n11 += nArray3[n3];
                    continue;
                }
                n = (int)Math.round(d2);
                if (n < 2 || n > 8 || !((d = Math.abs(dArray[n4] - (double)n * dArray[n3])) < clusterWidth * (double)n)) continue;
                d6 += dArray[n3] * (double)n * (double)nArray3[n3];
                n11 += nArray3[n3];
            }
            for (d5 = d6 / (double)n11; d5 < minIBI; d5 *= 2.0) {
            }
            while (d5 > maxIBI) {
                d5 /= 2.0;
            }
            if (!(d5 >= minIBI)) continue;
            agentList.add(new Agent(d5));
            if (!debug) continue;
            System.out.printf(" %5.3f", d5);
        }
        if (debug) {
            System.out.println(" IBI");
        }
        return agentList;
    }

    protected static int top(int n) {
        return n + 25;
    }

    public static void newInduction(EventList eventList) {
        int n;
        int[] nArray = new int[2500];
        for (int i = 0; i < 2500; ++i) {
            nArray[i] = 0;
        }
        ListIterator<Event> listIterator = eventList.listIterator();
        block1: while (listIterator.hasNext()) {
            Event event = listIterator.next();
            ListIterator<Event> listIterator2 = eventList.listIterator();
            Event event2 = listIterator2.next();
            while (event2 != event) {
                event2 = listIterator2.next();
            }
            while (listIterator2.hasNext()) {
                event2 = listIterator2.next();
                n = (int)Math.round((event.keyDown - event2.keyDown) * 1000.0);
                if (n >= 2500) continue block1;
                int n2 = n;
                nArray[n2] = nArray[n2] + 1;
            }
        }
        int[] nArray2 = new int[10];
        int[] nArray3 = new int[10];
        for (n = 0; n < 10; ++n) {
            int n3;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = n3 = 70;
            while (n3 < 2500) {
                if (n3 >= Induction.top(n7)) {
                    n4 -= nArray[n7++];
                    continue;
                }
                if ((n4 += nArray[n3++]) <= n5) continue;
                n5 = n4;
                n6 = n7;
            }
            if (n5 == 0) break;
            n3 = Induction.top(n6);
            if (n3 > 2500) {
                n3 = 2500;
            }
            n4 = 0;
            int n8 = 0;
            for (n7 = n6; n7 < n3; ++n7) {
                n4 += n7 * nArray[n7];
                n8 += nArray[n7];
                nArray[n7] = 0;
            }
            if (n8 != n5) {
                System.err.println("Rounding error in newInduction");
            }
            nArray2[n] = n4 / n8;
            nArray3[n] = n8;
            System.out.printf(" %5.3f", (double)n4 / 1000.0 / (double)n8);
        }
        System.out.println(" IBI");
    }
}

