/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.beatroot;

import java.util.LinkedList;

public class Peaks {
    public static boolean debug = false;
    public static int pre = 3;
    public static int post = 1;

    public static int findPeaks(double[] dArray, int[] nArray, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = dArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            int n6;
            int n7 = i - n;
            if (n7 < 0) {
                n7 = 0;
            }
            if ((n6 = i + n + 1) > dArray.length) {
                n6 = dArray.length;
            }
            n3 = n7++;
            while (n7 < n6) {
                if (dArray[n7] > dArray[n3]) {
                    n3 = n7;
                }
                ++n7;
            }
            if (n3 != i) continue;
            for (n5 = n2; n5 > 0 && !(dArray[n3] <= dArray[nArray[n5 - 1]]); --n5) {
                if (n5 >= nArray.length) continue;
                nArray[n5] = nArray[n5 - 1];
            }
            if (n5 != nArray.length) {
                nArray[n5] = n3;
            }
            if (n2 == nArray.length) continue;
            ++n2;
        }
        return n2;
    }

    public static LinkedList<Integer> findPeaks(double[] dArray, int n, double d) {
        return Peaks.findPeaks(dArray, n, d, 0.0, false);
    }

    public static LinkedList<Integer> findPeaks(double[] dArray, int n, double d, double d2, boolean bl) {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        int n2 = 0;
        int n3 = dArray.length;
        double d3 = dArray[0];
        for (int i = 0; i < n3; ++i) {
            int n4;
            int n5;
            if ((d3 = d2 * d3 + (1.0 - d2) * dArray[i]) < dArray[i]) {
                d3 = dArray[i];
            }
            if ((n5 = i - n) < 0) {
                n5 = 0;
            }
            if ((n4 = i + n + 1) > dArray.length) {
                n4 = dArray.length;
            }
            n2 = n5++;
            while (n5 < n4) {
                if (dArray[n5] > dArray[n2]) {
                    n2 = n5;
                }
                ++n5;
            }
            if (n2 != i) continue;
            if (Peaks.overThreshold(dArray, n2, n, d, bl, d3)) {
                if (debug) {
                    System.out.println(" peak");
                }
                linkedList.add(new Integer(n2));
                continue;
            }
            if (!debug) continue;
            System.out.println();
        }
        return linkedList;
    }

    public static double expDecayWithHold(double d, double d2, double[] dArray, int n, int n2) {
        while (n < n2) {
            if ((d = d2 * d + (1.0 - d2) * dArray[n]) < dArray[n]) {
                d = dArray[n];
            }
            ++n;
        }
        return d;
    }

    public static boolean overThreshold(double[] dArray, int n, int n2, double d, boolean bl, double d2) {
        if (debug) {
            System.out.printf("%4d : %6.3f     Av1: %6.3f    ", n, dArray[n], d2);
        }
        if (dArray[n] < d2) {
            return false;
        }
        if (bl) {
            int n3;
            int n4 = n - pre * n2;
            if (n4 < 0) {
                n4 = 0;
            }
            if ((n3 = n + post * n2) > dArray.length) {
                n3 = dArray.length;
            }
            double d3 = 0.0;
            int n5 = n3 - n4;
            while (n4 < n3) {
                d3 += dArray[n4++];
            }
            if (debug) {
                System.out.printf("    %6.3f    %6.3f   ", d3 / (double)n5, dArray[n] - d3 / (double)n5 - d);
            }
            return dArray[n] > d3 / (double)n5 + d;
        }
        return dArray[n] > d;
    }

    public static void normalise(double[] dArray) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += dArray[i] * dArray[i];
        }
        double d3 = d / (double)dArray.length;
        double d4 = Math.sqrt((d2 - d * d3) / (double)dArray.length);
        if (d4 == 0.0) {
            d4 = 1.0;
        }
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = (dArray[i] - d3) / d4;
        }
    }

    public static void getSlope(double[] dArray, double d, int n, double[] dArray2) {
        int n2;
        int n3 = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (n2 = 0; n2 < n; ++n2) {
            double d6 = (double)n2 * d;
            d2 += d6;
            d3 += d6 * d6;
            d4 += dArray[n2];
            d5 += d6 * dArray[n2];
        }
        double d7 = (double)n * d3 - d2 * d2;
        while (n3 < n / 2) {
            dArray2[n3] = ((double)n * d5 - d2 * d4) / d7;
            ++n3;
        }
        while (n3 < dArray.length - (n + 1) / 2) {
            dArray2[n3] = ((double)n * d5 - d2 * d4) / d7;
            d5 += d * ((double)n * dArray[n2] - (d4 += dArray[n2] - dArray[n2 - n]));
            ++n3;
            ++n2;
        }
        while (n3 < dArray.length) {
            dArray2[n3] = ((double)n * d5 - d2 * d4) / d7;
            ++n3;
        }
    }

    public static double min(double[] dArray) {
        return dArray[Peaks.imin(dArray)];
    }

    public static double max(double[] dArray) {
        return dArray[Peaks.imax(dArray)];
    }

    public static int imin(double[] dArray) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] < dArray[n])) continue;
            n = i;
        }
        return n;
    }

    public static int imax(double[] dArray) {
        int n = 0;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(dArray[i] > dArray[n])) continue;
            n = i;
        }
        return n;
    }
}

