/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.effects;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class DelayEffect
implements AudioProcessor {
    private double sampleRate;
    private float[] echoBuffer;
    private int position;
    private float decay;
    private double newEchoLength;

    public DelayEffect(double d, double d2, double d3) {
        this.sampleRate = d3;
        this.setDecay(d2);
        this.setEchoLength(d);
        this.applyNewEchoLength();
    }

    public void setEchoLength(double d) {
        this.newEchoLength = d;
    }

    private void applyNewEchoLength() {
        if (this.newEchoLength != -1.0) {
            float[] fArray = new float[(int)(this.sampleRate * this.newEchoLength)];
            if (this.echoBuffer != null) {
                for (int i = 0; i < fArray.length; ++i) {
                    if (this.position >= this.echoBuffer.length) {
                        this.position = 0;
                    }
                    fArray[i] = this.echoBuffer[this.position];
                    ++this.position;
                }
            }
            this.echoBuffer = fArray;
            this.newEchoLength = -1.0;
        }
    }

    public void setDecay(double d) {
        this.decay = (float)d;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int n;
        float[] fArray = audioEvent.getFloatBuffer();
        for (int i = n = audioEvent.getOverlap(); i < fArray.length; ++i) {
            if (this.position >= this.echoBuffer.length) {
                this.position = 0;
            }
            fArray[i] = fArray[i] + this.echoBuffer[this.position] * this.decay;
            this.echoBuffer[this.position] = fArray[i];
            ++this.position;
        }
        this.applyNewEchoLength();
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

