/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.effects;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public class FlangerEffect
implements AudioProcessor {
    private float[] flangerBuffer;
    private int writePosition;
    private float dry;
    private float wet;
    private double lfoFrequency;
    private double sampleRate;

    public FlangerEffect(double d, double d2, double d3, double d4) {
        this.flangerBuffer = new float[(int)(d3 * d)];
        this.sampleRate = d3;
        this.lfoFrequency = d4;
        this.wet = (float)d2;
        this.dry = (float)(1.0 - d2);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        int n = audioEvent.getOverlap();
        double d = Math.PI * 2 * this.lfoFrequency / 2.0;
        double d2 = audioEvent.getTimeStamp();
        double d3 = 1.0 / this.sampleRate;
        for (int i = n; i < fArray.length; ++i) {
            double d4 = (double)(this.flangerBuffer.length - 1) * Math.sin(d * d2);
            d2 += d3;
            int n2 = (int)Math.round(Math.abs(d4));
            if (this.writePosition >= this.flangerBuffer.length) {
                this.writePosition = 0;
            }
            this.flangerBuffer[this.writePosition] = fArray[i];
            int n3 = this.writePosition - n2;
            if (n3 < 0) {
                n3 += this.flangerBuffer.length;
            }
            ++this.writePosition;
            fArray[i] = this.dry * fArray[i] + this.wet * this.flangerBuffer[n3];
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public void setFlangerLength(double d) {
        this.flangerBuffer = new float[(int)(this.sampleRate * d)];
    }

    public void setLFOFrequency(double d) {
        this.lfoFrequency = d;
    }

    public void setWet(double d) {
        this.wet = (float)d;
        this.dry = (float)(1.0 - d);
    }

    public void setDry(double d) {
        this.dry = (float)d;
        this.wet = (float)(1.0 - d);
    }
}

