/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.filters;

import be.tarsos.dsp.filters.IIRFilter;

public class BandPass
extends IIRFilter {
    private float bw;

    public BandPass(float f, float f2, float f3) {
        super(f, f3);
        this.setBandWidth(f2);
    }

    public void setBandWidth(float f) {
        this.bw = f / this.getSampleRate();
        this.calcCoeff();
    }

    public float getBandWidth() {
        return this.bw * this.getSampleRate();
    }

    @Override
    protected void calcCoeff() {
        float f = 1.0f - 3.0f * this.bw;
        float f2 = this.getFrequency() / this.getSampleRate();
        float f3 = 2.0f * (float)Math.cos(Math.PI * 2 * (double)f2);
        float f4 = (1.0f - f * f3 + f * f) / (2.0f - f3);
        this.a = new float[]{1.0f - f4, (f4 - f) * f3, f * f - f4};
        this.b = new float[]{f * f3, -f * f};
    }
}

