/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.filters;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;

public abstract class IIRFilter
implements AudioProcessor {
    protected float[] b;
    protected float[] a;
    protected float[] in;
    protected float[] out;
    private float frequency;
    private final float sampleRate;

    public IIRFilter(float f, float f2) {
        this.sampleRate = f2;
        this.frequency = f;
        this.calcCoeff();
        this.in = new float[this.a.length];
        this.out = new float[this.b.length];
    }

    public void setFrequency(float f) {
        this.frequency = f;
        this.calcCoeff();
    }

    protected final float getFrequency() {
        return this.frequency;
    }

    protected final float getSampleRate() {
        return this.sampleRate;
    }

    protected abstract void calcCoeff();

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        for (int i = audioEvent.getOverlap(); i < fArray.length; ++i) {
            int n;
            System.arraycopy(this.in, 0, this.in, 1, this.in.length - 1);
            this.in[0] = fArray[i];
            float f = 0.0f;
            for (n = 0; n < this.a.length; ++n) {
                f += this.a[n] * this.in[n];
            }
            for (n = 0; n < this.b.length; ++n) {
                f += this.b[n] * this.out[n];
            }
            System.arraycopy(this.out, 0, this.out, 1, this.out.length - 1);
            this.out[0] = f;
            fArray[i] = f;
        }
        return true;
    }

    @Override
    public void processingFinished() {
    }
}

