/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.granulator;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.granulator.Grain;
import be.tarsos.dsp.util.fft.CosineWindow;
import java.util.ArrayList;
import java.util.Arrays;

public class Granulator
implements AudioProcessor {
    public static final float ADAPTIVE_INTERP_LOW_THRESH = 0.5f;
    public static final float ADAPTIVE_INTERP_HIGH_THRESH = 2.5f;
    protected double position;
    private double positionIncrement;
    private float grainInterval;
    private float grainSize;
    private float grainRandomness;
    private float timeSinceLastGrain;
    private double msPerSample;
    private float pitchFactor;
    private float timeStretchFactor;
    private ArrayList<Grain> grains = new ArrayList();
    private ArrayList<Grain> freeGrains = new ArrayList();
    private ArrayList<Grain> deadGrains = new ArrayList();
    private final float[] window;
    private final float[] audioBuffer;
    private int audioBufferWatermark;
    private final float[] outputBuffer;
    private boolean firstGrain = true;

    public Granulator(float f, int n) {
        this.audioBuffer = new float[(int)(720.0f * f)];
        this.audioBufferWatermark = 0;
        this.pitchFactor = 1.0f;
        this.grainInterval = 40.0f;
        this.grainSize = 100.0f;
        this.grainRandomness = 0.1f;
        this.window = new CosineWindow().generateCurve(n);
        this.outputBuffer = new float[n];
        this.positionIncrement = this.msPerSample = (double)(1000.0f / f);
    }

    public void start() {
        this.timeSinceLastGrain = 0.0f;
    }

    private void firstGrain() {
        if (this.firstGrain) {
            Grain grain = new Grain();
            grain.position = this.position;
            grain.age = this.grainSize / 4.0f;
            grain.grainSize = this.grainSize;
            this.grains.add(grain);
            this.firstGrain = false;
            this.timeSinceLastGrain = this.grainInterval / 2.0f;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        System.arraycopy(audioEvent.getFloatBuffer(), 0, this.audioBuffer, this.audioBufferWatermark, audioEvent.getBufferSize());
        this.audioBufferWatermark += audioEvent.getBufferSize();
        Arrays.fill(this.outputBuffer, 0.0f);
        this.firstGrain();
        int n = audioEvent.getBufferSize();
        for (int i = 0; i < n; ++i) {
            Grain grain;
            int n2;
            if (this.timeSinceLastGrain > this.grainInterval) {
                Grain grain2 = null;
                if (this.freeGrains.size() > 0) {
                    grain2 = this.freeGrains.get(0);
                    this.freeGrains.remove(0);
                } else {
                    grain2 = new Grain();
                }
                grain2.reset(this.grainSize, this.grainRandomness, this.position, this.timeStretchFactor, this.pitchFactor);
                this.grains.add(grain2);
                this.timeSinceLastGrain = 0.0f;
            }
            for (n2 = 0; n2 < this.grains.size(); ++n2) {
                grain = this.grains.get(n2);
                float f = this.getValueFraction((float)(grain.age / grain.grainSize));
                this.getFrameLinear(grain.position);
                double d = this.pitchFactor > 2.5f ? (double)this.getFrameNoInterp(grain.position) : (this.pitchFactor > 0.5f ? this.getFrameLinear(grain.position) : (double)this.getFrameCubic(grain.position));
                int n3 = i;
                this.outputBuffer[n3] = this.outputBuffer[n3] + (float)(d *= (double)f);
            }
            this.position += this.positionIncrement * (double)this.timeStretchFactor;
            for (n2 = 0; n2 < this.grains.size(); ++n2) {
                grain = this.grains.get(n2);
                this.calculateNextGrainPosition(grain);
            }
            this.timeSinceLastGrain = (float)((double)this.timeSinceLastGrain + this.msPerSample);
            for (n2 = 0; n2 < this.grains.size(); ++n2) {
                grain = this.grains.get(n2);
                if (!(grain.age > grain.grainSize)) continue;
                this.freeGrains.add(grain);
                this.deadGrains.add(grain);
            }
            for (n2 = 0; n2 < this.deadGrains.size(); ++n2) {
                grain = this.deadGrains.get(n2);
                this.grains.remove(grain);
            }
            this.deadGrains.clear();
        }
        audioEvent.setFloatBuffer(this.outputBuffer);
        return true;
    }

    public double getFrameLinear(double d) {
        double d2 = 0.0;
        double d3 = this.msToSamples(d);
        int n = (int)Math.floor(d3);
        if (n > 0 && n < this.audioBufferWatermark) {
            double d4 = d3 - (double)n;
            if (n == this.audioBufferWatermark - 1) {
                d2 = this.audioBuffer[n];
            } else {
                double d5 = this.audioBuffer[n];
                double d6 = this.audioBuffer[n];
                d2 = (float)((1.0 - d4) * d5 + d4 * d6);
            }
        }
        return d2;
    }

    public float getFrameNoInterp(double d) {
        double d2 = this.msToSamples(d);
        int n = (int)Math.floor(d2);
        return this.audioBuffer[n];
    }

    public float getFrameCubic(double d) {
        float f = (float)this.msToSamples(d);
        float f2 = 0.0f;
        int n = (int)Math.floor(f);
        float f3 = f - (float)n;
        if (n >= 0 && n < this.audioBufferWatermark - 1) {
            float f4;
            if (--n < 0) {
                f4 = this.audioBuffer[0];
                n = 0;
            } else {
                f4 = this.audioBuffer[n++];
            }
            float f5 = this.audioBuffer[n++];
            float f6 = n >= this.audioBufferWatermark ? this.audioBuffer[this.audioBufferWatermark - 1] : this.audioBuffer[n++];
            float f7 = n >= this.audioBufferWatermark ? this.audioBuffer[this.audioBufferWatermark - 1] : this.audioBuffer[n++];
            float f8 = f3 * f3;
            float f9 = f7 - f6 - f4 + f5;
            float f10 = f4 - f5 - f9;
            float f11 = f6 - f4;
            float f12 = f5;
            f2 = f9 * f3 * f8 + f10 * f8 + f11 * f3 + f12;
        }
        return f2;
    }

    private double msToSamples(double d) {
        return d / this.msPerSample;
    }

    @Override
    public void processingFinished() {
    }

    public float getValueFraction(float f) {
        float f2 = f * (float)this.window.length;
        int n = (int)f2;
        float f3 = f2 - (float)n;
        int n2 = (n + 1) % this.window.length;
        return (1.0f - f3) * this.window[n] + f3 * this.window[n2];
    }

    private void calculateNextGrainPosition(Grain grain) {
        int n = this.timeStretchFactor >= 0.0f ? 1 : -1;
        grain.age += this.msPerSample;
        grain.position += (double)n * this.positionIncrement * (double)this.pitchFactor;
    }

    public void setTimestretchFactor(float f) {
        this.timeStretchFactor = f;
    }

    public void setPitchShiftFactor(float f) {
        this.pitchFactor = f;
    }

    public void setGrainInterval(int n) {
        this.grainInterval = n;
    }

    public void setGrainSize(int n) {
        this.grainSize = n;
    }

    public void setGrainRandomness(float f) {
        this.grainRandomness = f;
    }

    public void setPosition(float f) {
        this.position = f * 1000.0f;
    }
}

