/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.granulator;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.granulator.Grain;
import be.tarsos.dsp.util.fft.CosineWindow;
import java.util.Arrays;

public class OptimizedGranulator
implements AudioProcessor {
    public static final float ADAPTIVE_INTERP_LOW_THRESH = 0.5f;
    public static final float ADAPTIVE_INTERP_HIGH_THRESH = 2.5f;
    protected double position;
    private double audioSampleLength;
    private float grainInterval;
    private float grainSize;
    private float grainRandomness;
    private float timeSinceLastGrain;
    private float pitchFactor;
    private float timeStretchFactor;
    private Grain[] grains = new Grain[50];
    private final float[] window;
    private final float[] audioBuffer;
    private int audioBufferWatermark;
    private final float[] outputBuffer;
    private boolean firstGrain = true;

    public OptimizedGranulator(float f, int n) {
        for (int i = 0; i < this.grains.length; ++i) {
            this.grains[i] = new Grain();
        }
        this.audioBuffer = new float[9600];
        this.audioBufferWatermark = 0;
        this.pitchFactor = 1.0f;
        this.grainInterval = 40.0f;
        this.grainSize = 100.0f;
        this.grainRandomness = 0.1f;
        this.window = new CosineWindow().generateCurve(512);
        this.outputBuffer = new float[n];
        this.audioSampleLength = 1000.0f / f;
    }

    public void start() {
        this.timeSinceLastGrain = 0.0f;
    }

    private void firstGrain() {
        if (this.firstGrain) {
            Grain grain = this.grains[0];
            grain.position = this.position;
            grain.age = this.grainSize / 4.0f;
            grain.grainSize = this.grainSize;
            this.firstGrain = false;
            this.timeSinceLastGrain = this.grainInterval / 2.0f;
        }
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int n;
        int n2;
        int n3 = audioEvent.getBufferSize();
        for (n2 = 0; n2 < n3; ++n2) {
            this.audioBuffer[this.audioBufferWatermark] = audioEvent.getFloatBuffer()[n2];
            ++this.audioBufferWatermark;
            if (this.audioBufferWatermark != this.audioBuffer.length) continue;
            this.audioBufferWatermark = 0;
        }
        System.out.println("Buffer water mark:" + this.audioBufferWatermark);
        Arrays.fill(this.outputBuffer, 0.0f);
        this.firstGrain();
        n2 = 0;
        for (n = 0; n < this.grains.length; ++n) {
            if (!this.grains[n].active) continue;
            ++n2;
        }
        System.out.println("Active grains = " + n2);
        for (n = 0; n < n3; ++n) {
            int n4;
            if (this.timeSinceLastGrain > this.grainInterval) {
                Grain grain = null;
                for (int i = 0; i < this.grains.length; ++i) {
                    if (this.grains[i].active) continue;
                    grain = this.grains[i];
                    grain.reset(this.grainSize, this.grainRandomness, this.position, this.timeStretchFactor, this.pitchFactor);
                    this.timeSinceLastGrain = 0.0f;
                    break;
                }
            }
            for (n4 = 0; n4 < this.grains.length; ++n4) {
                Grain grain = this.grains[n4];
                if (!grain.active) continue;
                float f = this.getValueFraction((float)(grain.age / grain.grainSize));
                double d = this.getFrameNoInterp(grain.position);
                int n5 = n;
                this.outputBuffer[n5] = this.outputBuffer[n5] + (float)(d *= (double)f);
            }
            this.position += this.audioSampleLength * (double)this.timeStretchFactor;
            for (n4 = 0; n4 < this.grains.length; ++n4) {
                Grain grain = this.grains[n4];
                if (!grain.active) continue;
                this.calculateNextGrainPosition(grain);
                if (!(grain.age > grain.grainSize)) continue;
                grain.active = false;
            }
            this.timeSinceLastGrain = (float)((double)this.timeSinceLastGrain + this.audioSampleLength);
        }
        for (n = 0; n < n3; ++n) {
            this.outputBuffer[n] = this.outputBuffer[n] / 5.0f;
        }
        audioEvent.setFloatBuffer(this.outputBuffer);
        return true;
    }

    public double getFrameLinear(double d) {
        double d2 = 0.0;
        double d3 = this.msToSamples(d);
        int n = (int)Math.floor(d3);
        if (n > 0 && n < this.audioBufferWatermark) {
            double d4 = d3 - (double)n;
            if (n == this.audioBufferWatermark - 1) {
                d2 = this.audioBuffer[n];
            } else {
                double d5 = this.audioBuffer[n];
                double d6 = this.audioBuffer[n];
                d2 = (float)((1.0 - d4) * d5 + d4 * d6);
            }
        }
        return d2;
    }

    public float getFrameNoInterp(double d) {
        double d2 = this.msToSamples(d);
        int n = (int)Math.floor(d2);
        return this.audioBuffer[n];
    }

    public float getFrameCubic(double d) {
        float f = (float)this.msToSamples(d);
        float f2 = 0.0f;
        int n = (int)Math.floor(f);
        float f3 = f - (float)n;
        if (n >= 0 && n < this.audioBufferWatermark - 1) {
            float f4;
            if (--n < 0) {
                f4 = this.audioBuffer[0];
                n = 0;
            } else {
                f4 = this.audioBuffer[n++];
            }
            float f5 = this.audioBuffer[n++];
            float f6 = n >= this.audioBufferWatermark ? this.audioBuffer[this.audioBufferWatermark - 1] : this.audioBuffer[n++];
            float f7 = n >= this.audioBufferWatermark ? this.audioBuffer[this.audioBufferWatermark - 1] : this.audioBuffer[n++];
            float f8 = f3 * f3;
            float f9 = f7 - f6 - f4 + f5;
            float f10 = f4 - f5 - f9;
            float f11 = f6 - f4;
            float f12 = f5;
            f2 = f9 * f3 * f8 + f10 * f8 + f11 * f3 + f12;
        }
        return f2;
    }

    private double msToSamples(double d) {
        double d2 = d / this.audioSampleLength;
        if (d2 < 0.0) {
            d2 = 0.0;
        } else {
            int n = (int)(d2 / (double)this.audioBuffer.length);
            d2 -= (double)(n * this.audioBuffer.length);
        }
        return d2;
    }

    @Override
    public void processingFinished() {
    }

    public float getValueFraction(float f) {
        float f2 = f * (float)this.window.length;
        if (f >= 1.0f) {
            f2 -= 1.0f;
        }
        int n = (int)f2;
        float f3 = f2 - (float)n;
        int n2 = (n + 1) % this.window.length;
        return (1.0f - f3) * this.window[n] + f3 * this.window[n2];
    }

    private void calculateNextGrainPosition(Grain grain) {
        int n = this.timeStretchFactor >= 0.0f ? 1 : -1;
        grain.age += this.audioSampleLength;
        grain.position += (double)n * this.audioSampleLength * (double)this.pitchFactor;
    }

    public void setTimestretchFactor(float f) {
        this.timeStretchFactor = f;
    }

    public void setPitchShiftFactor(float f) {
        this.pitchFactor = f;
    }

    public void setGrainInterval(int n) {
        this.grainInterval = n;
    }

    public void setGrainSize(int n) {
        this.grainSize = n;
    }

    public void setGrainRandomness(float f) {
        this.grainRandomness = f;
    }

    public void setPosition(float f) {
        this.position = f * 1000.0f;
    }
}

