/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io;

import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.util.FFMPEGDownloader;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteOrder;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PipeDecoder {
    private static final Logger LOG = Logger.getLogger(PipeDecoder.class.getName());
    private final String pipeEnvironment;
    private final String pipeArgument;
    private final String pipeCommand;
    private final int pipeBuffer;
    private boolean printErrorstream = false;
    private String decoderBinaryAbsolutePath;

    public PipeDecoder() {
        this.pipeBuffer = 10000;
        if (System.getProperty("os.name").indexOf("indows") > 0) {
            this.pipeEnvironment = "cmd.exe";
            this.pipeArgument = "/C";
        } else if (new File("/bin/bash").exists()) {
            this.pipeEnvironment = "/bin/bash";
            this.pipeArgument = "-c";
        } else if (new File("/system/bin/sh").exists()) {
            this.pipeEnvironment = "/system/bin/sh";
            this.pipeArgument = "-c";
        } else {
            LOG.severe("Coud not find a command line environment (cmd.exe or /bin/bash)");
            throw new Error("Decoding via a pipe will not work: Coud not find a command line environment (cmd.exe or /bin/bash)");
        }
        String string = System.getenv("PATH");
        String string2 = " -ss %input_seeking%  %number_of_seconds% -i \"%resource%\" -vn -ar %sample_rate% -ac %channels% -sample_fmt s16 -f s16le pipe:1";
        if (this.isAvailable("ffmpeg")) {
            LOG.info("found ffmpeg on the path (" + string + "). Will use ffmpeg for decoding media files.");
            this.pipeCommand = "ffmpeg" + string2;
        } else if (this.isAvailable("avconv")) {
            LOG.info("found avconv on your path(" + string + "). Will use avconv for decoding media files.");
            this.pipeCommand = "avconv" + string2;
        } else {
            if (this.isAndroid()) {
                String string3 = System.getProperty("java.io.tmpdir");
                this.printErrorstream = true;
                File file = new File(string3, "ffmpeg");
                if (file.exists() && file.length() > 1000000L && file.canExecute()) {
                    this.decoderBinaryAbsolutePath = file.getAbsolutePath();
                } else {
                    LOG.severe("Could not find an ffmpeg binary for your Android system. Did you forget calling: 'new AndroidFFMPEGLocator(this);' ?");
                    LOG.severe("Tried to unpack a statically compiled ffmpeg binary for your architecture to: " + file.getAbsolutePath());
                }
            } else {
                LOG.warning("Dit not find ffmpeg or avconv on your path(" + string + "), will try to download it automatically.");
                FFMPEGDownloader fFMPEGDownloader = new FFMPEGDownloader();
                this.decoderBinaryAbsolutePath = fFMPEGDownloader.ffmpegBinary();
                if (this.decoderBinaryAbsolutePath == null) {
                    LOG.severe("Could not download an ffmpeg binary automatically for your system.");
                }
            }
            if (this.decoderBinaryAbsolutePath == null) {
                this.pipeCommand = "false";
                throw new Error("Decoding via a pipe will not work: Could not find an ffmpeg binary for your system");
            }
            this.pipeCommand = '\"' + this.decoderBinaryAbsolutePath + '\"' + string2;
        }
    }

    private boolean isAvailable(String string) {
        try {
            Runtime.getRuntime().exec(string + " -version");
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public PipeDecoder(String string, String string2, String string3, String string4, int n) {
        this.pipeEnvironment = string;
        this.pipeArgument = string2;
        this.pipeCommand = string3;
        this.pipeBuffer = n;
    }

    public InputStream getDecodedStream(String string, int n, double d, double d2) {
        try {
            String string2 = this.pipeCommand;
            string2 = string2.replace("%input_seeking%", String.valueOf(d));
            string2 = d2 > 0.0 ? string2.replace("%number_of_seconds%", "-t " + String.valueOf(d2)) : string2.replace("%number_of_seconds%", "");
            string2 = string2.replace("%resource%", string);
            string2 = string2.replace("%sample_rate%", String.valueOf(n));
            string2 = string2.replace("%channels%", "1");
            ProcessBuilder processBuilder = new ProcessBuilder(this.pipeEnvironment, this.pipeArgument, string2);
            LOG.info("Starting piped decoding process for " + string);
            LOG.info(" with command: " + string2);
            final Process process = processBuilder.start();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream(), this.pipeBuffer){

                @Override
                public void close() throws IOException {
                    super.close();
                    process.destroy();
                }
            };
            if (this.printErrorstream) {
                new ErrorStreamGobbler(process.getErrorStream(), LOG).start();
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                        LOG.info("Finished piped decoding process");
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.severe("Interrupted while waiting for decoding sub process exit.");
                        interruptedException.printStackTrace();
                    }
                }
            }, "Decoding Pipe").start();
            return bufferedInputStream;
        }
        catch (IOException iOException) {
            LOG.warning("IO exception while decoding audio via sub process." + iOException.getMessage());
            iOException.printStackTrace();
            return null;
        }
    }

    public double getDuration(String string) {
        double d = -1.0;
        try {
            String string2 = "ffmpeg -i \"%resource%\"";
            string2 = string2.replace("%resource%", string);
            ProcessBuilder processBuilder = new ProcessBuilder(this.pipeEnvironment, this.pipeArgument, string2);
            LOG.info("Starting duration command for " + string);
            LOG.fine(" with command: " + string2);
            final Process process = processBuilder.start();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(process.getInputStream(), this.pipeBuffer){

                @Override
                public void close() throws IOException {
                    super.close();
                    process.destroy();
                }
            };
            ErrorStreamStringGlobber errorStreamStringGlobber = new ErrorStreamStringGlobber(process.getErrorStream());
            errorStreamStringGlobber.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        process.waitFor();
                        LOG.info("Finished piped decoding process");
                    }
                    catch (InterruptedException interruptedException) {
                        LOG.severe("Interrupted while waiting for decoding sub process exit.");
                        interruptedException.printStackTrace();
                    }
                }
            }, "Decoding Pipe").run();
            String string3 = errorStreamStringGlobber.getErrorStreamAsString();
            Pattern pattern = Pattern.compile(".*\\s.*Duration:\\s+(\\d\\d):(\\d\\d):(\\d\\d)\\.(\\d\\d), .*", 40);
            Matcher matcher = pattern.matcher(string3);
            if (matcher.find()) {
                d = (double)(Integer.valueOf(matcher.group(1)) * 3600 + Integer.valueOf(matcher.group(2)) * 60 + Integer.valueOf(matcher.group(3)) * 1) + Double.valueOf("." + matcher.group(4));
            }
        }
        catch (IOException iOException) {
            LOG.warning("IO exception while decoding audio via sub process." + iOException.getMessage());
            iOException.printStackTrace();
        }
        return d;
    }

    public void printBinaryInfo() {
        try {
            Process process = Runtime.getRuntime().exec(this.decoderBinaryAbsolutePath);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                System.out.println(string);
            }
            bufferedReader.close();
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static TarsosDSPAudioFormat getTargetAudioFormat(int n) {
        TarsosDSPAudioFormat tarsosDSPAudioFormat = new TarsosDSPAudioFormat(TarsosDSPAudioFormat.Encoding.PCM_SIGNED, n, 16, 1, 2, n, ByteOrder.BIG_ENDIAN.equals(ByteOrder.nativeOrder()));
        return tarsosDSPAudioFormat;
    }

    private boolean isAndroid() {
        try {
            Class.forName("android.app.Activity");
            System.out.println("Running on Android!");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private class ErrorStreamStringGlobber
    extends Thread {
        private final InputStream is;
        private final StringBuilder sb;

        private ErrorStreamStringGlobber(InputStream inputStream) {
            this.is = inputStream;
            this.sb = new StringBuilder();
        }

        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.sb.append(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }

        public String getErrorStreamAsString() {
            return this.sb.toString();
        }
    }

    private class ErrorStreamGobbler
    extends Thread {
        private final InputStream is;
        private final Logger logger;

        private ErrorStreamGobbler(InputStream inputStream, Logger logger) {
            this.is = inputStream;
            this.logger = logger;
        }

        @Override
        public void run() {
            try {
                InputStreamReader inputStreamReader = new InputStreamReader(this.is);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                String string = null;
                while ((string = bufferedReader.readLine()) != null) {
                    this.logger.info(string);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

