/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io;

import be.tarsos.dsp.io.PipeDecoder;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import be.tarsos.dsp.io.UniversalAudioInputStream;
import be.tarsos.dsp.util.AudioResourceUtils;
import java.io.InputStream;

public class PipedAudioStream {
    private final String resource;
    private static PipeDecoder pipeDecoder = new PipeDecoder();
    private final PipeDecoder decoder;

    public static void setDecoder(PipeDecoder pipeDecoder) {
        PipedAudioStream.pipeDecoder = pipeDecoder;
    }

    public PipedAudioStream(String string) {
        this.resource = AudioResourceUtils.sanitizeResource(string);
        this.decoder = pipeDecoder;
    }

    public TarsosDSPAudioInputStream getMonoStream(int n, double d) {
        return this.getMonoStream(n, d, -1.0);
    }

    private TarsosDSPAudioFormat getTargetFormat(int n) {
        return new TarsosDSPAudioFormat(n, 16, 1, true, false);
    }

    public TarsosDSPAudioInputStream getMonoStream(int n, double d, double d2) {
        InputStream inputStream = null;
        inputStream = this.decoder.getDecodedStream(this.resource, n, d, d2);
        return new UniversalAudioInputStream(inputStream, this.getTargetFormat(n));
    }
}

