/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io.jvm;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.io.PipedAudioStream;
import be.tarsos.dsp.io.TarsosDSPAudioFloatConverter;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import be.tarsos.dsp.io.jvm.JVMAudioInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioDispatcherFactory {
    public static AudioDispatcher fromDefaultMicrophone(int n, int n2) throws LineUnavailableException {
        return AudioDispatcherFactory.fromDefaultMicrophone(44100, n, n2);
    }

    public static AudioDispatcher fromDefaultMicrophone(int n, int n2, int n3) throws LineUnavailableException {
        AudioFormat audioFormat = new AudioFormat(n, 16, 1, true, true);
        TargetDataLine targetDataLine = AudioSystem.getTargetDataLine(audioFormat);
        targetDataLine.open(audioFormat, n2);
        targetDataLine.start();
        AudioInputStream audioInputStream = new AudioInputStream(targetDataLine);
        JVMAudioInputStream jVMAudioInputStream = new JVMAudioInputStream(audioInputStream);
        return new AudioDispatcher(jVMAudioInputStream, n2, n3);
    }

    public static AudioDispatcher fromByteArray(byte[] byArray, AudioFormat audioFormat, int n, int n2) throws UnsupportedAudioFileException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        long l = byArray.length / audioFormat.getFrameSize();
        AudioInputStream audioInputStream = new AudioInputStream(byteArrayInputStream, audioFormat, l);
        JVMAudioInputStream jVMAudioInputStream = new JVMAudioInputStream(audioInputStream);
        return new AudioDispatcher(jVMAudioInputStream, n, n2);
    }

    public static AudioDispatcher fromURL(URL uRL, int n, int n2) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(uRL);
        JVMAudioInputStream jVMAudioInputStream = new JVMAudioInputStream(audioInputStream);
        return new AudioDispatcher(jVMAudioInputStream, n, n2);
    }

    public static AudioDispatcher fromPipe(String string, int n, int n2, int n3) {
        return AudioDispatcherFactory.fromPipe(string, n, n2, n3, 0.0);
    }

    public static AudioDispatcher fromPipe(String string, int n, int n2, int n3, double d) {
        if (new File(string).exists() && new File(string).isFile() && new File(string).canRead()) {
            PipedAudioStream pipedAudioStream = new PipedAudioStream(string);
            TarsosDSPAudioInputStream tarsosDSPAudioInputStream = pipedAudioStream.getMonoStream(n, d);
            return new AudioDispatcher(tarsosDSPAudioInputStream, n2, n3);
        }
        throw new IllegalArgumentException("The file " + string + " is not a readable file. Does it exist?");
    }

    public static AudioDispatcher fromPipe(String string, int n, int n2, int n3, double d, double d2) {
        if (new File(string).exists() && new File(string).isFile() && new File(string).canRead()) {
            PipedAudioStream pipedAudioStream = new PipedAudioStream(string);
            TarsosDSPAudioInputStream tarsosDSPAudioInputStream = pipedAudioStream.getMonoStream(n, d, d2);
            return new AudioDispatcher(tarsosDSPAudioInputStream, n2, n3);
        }
        throw new IllegalArgumentException("The file " + string + " is not a readable file. Does it exist?");
    }

    public static AudioDispatcher fromFile(File file, int n, int n2) throws UnsupportedAudioFileException, IOException {
        AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file);
        JVMAudioInputStream jVMAudioInputStream = new JVMAudioInputStream(audioInputStream);
        return new AudioDispatcher(jVMAudioInputStream, n, n2);
    }

    public static AudioDispatcher fromFloatArray(float[] fArray, int n, int n2, int n3) throws UnsupportedAudioFileException {
        AudioFormat audioFormat = new AudioFormat(n, 16, 1, true, false);
        TarsosDSPAudioFloatConverter tarsosDSPAudioFloatConverter = TarsosDSPAudioFloatConverter.getConverter(JVMAudioInputStream.toTarsosDSPFormat(audioFormat));
        byte[] byArray = new byte[fArray.length * audioFormat.getFrameSize()];
        tarsosDSPAudioFloatConverter.toByteArray(fArray, byArray);
        return AudioDispatcherFactory.fromByteArray(byArray, audioFormat, n2, n3);
    }
}

