/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io.jvm;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.jvm.JVMAudioInputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public final class AudioPlayer
implements AudioProcessor {
    private SourceDataLine line;
    private final AudioFormat format;

    public AudioPlayer(AudioFormat audioFormat) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat);
        this.format = audioFormat;
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.open();
        this.line.start();
    }

    public AudioPlayer(AudioFormat audioFormat, int n) throws LineUnavailableException {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, audioFormat, n);
        this.format = audioFormat;
        this.line = (SourceDataLine)AudioSystem.getLine(info);
        this.line.open(audioFormat, n * 2);
        System.out.println("Buffer size:" + this.line.getBufferSize());
        this.line.start();
    }

    public AudioPlayer(TarsosDSPAudioFormat tarsosDSPAudioFormat, int n) throws LineUnavailableException {
        this(JVMAudioInputStream.toAudioFormat(tarsosDSPAudioFormat), n);
    }

    public AudioPlayer(TarsosDSPAudioFormat tarsosDSPAudioFormat) throws LineUnavailableException {
        this(JVMAudioInputStream.toAudioFormat(tarsosDSPAudioFormat));
    }

    public long getMicroSecondPosition() {
        return this.line.getMicrosecondPosition();
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int n;
        int n2 = audioEvent.getOverlap() * this.format.getFrameSize();
        int n3 = audioEvent.getBufferSize() * this.format.getFrameSize() - n2;
        if (audioEvent.getTimeStamp() == 0.0) {
            n2 = 0;
            n3 = audioEvent.getBufferSize() * this.format.getFrameSize();
        }
        if ((n = this.line.write(audioEvent.getByteBuffer(), n2, n3)) != n3) {
            System.err.println(String.format("Expected to write %d bytes but only wrote %d bytes", n3, n));
        }
        return true;
    }

    @Override
    public void processingFinished() {
        this.line.drain();
        this.line.stop();
        this.line.close();
    }
}

