/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io.jvm;

import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.TarsosDSPAudioInputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public class JVMAudioInputStream
implements TarsosDSPAudioInputStream {
    private final AudioInputStream underlyingStream;
    private final TarsosDSPAudioFormat tarsosDSPAudioFormat;

    public JVMAudioInputStream(AudioInputStream audioInputStream) {
        this.underlyingStream = audioInputStream;
        this.tarsosDSPAudioFormat = JVMAudioInputStream.toTarsosDSPFormat(audioInputStream.getFormat());
    }

    @Override
    public long skip(long l) throws IOException {
        return this.underlyingStream.skip(l);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.underlyingStream.read(byArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        this.underlyingStream.close();
    }

    @Override
    public long getFrameLength() {
        return this.underlyingStream.getFrameLength();
    }

    @Override
    public TarsosDSPAudioFormat getFormat() {
        return this.tarsosDSPAudioFormat;
    }

    public static TarsosDSPAudioFormat toTarsosDSPFormat(AudioFormat audioFormat) {
        boolean bl = audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED;
        TarsosDSPAudioFormat tarsosDSPAudioFormat = new TarsosDSPAudioFormat(audioFormat.getSampleRate(), audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), bl, audioFormat.isBigEndian());
        return tarsosDSPAudioFormat;
    }

    public static AudioFormat toAudioFormat(TarsosDSPAudioFormat tarsosDSPAudioFormat) {
        boolean bl = tarsosDSPAudioFormat.getEncoding() == TarsosDSPAudioFormat.Encoding.PCM_SIGNED;
        AudioFormat audioFormat = new AudioFormat(tarsosDSPAudioFormat.getSampleRate(), tarsosDSPAudioFormat.getSampleSizeInBits(), tarsosDSPAudioFormat.getChannels(), bl, tarsosDSPAudioFormat.isBigEndian());
        return audioFormat;
    }
}

