/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.io.jvm;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.io.TarsosDSPAudioFormat;
import be.tarsos.dsp.io.jvm.JVMAudioInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;

public class WaveformWriter
implements AudioProcessor {
    private final AudioFormat format;
    private final File rawOutputFile;
    private final String fileName;
    private FileOutputStream rawOutputStream;
    private static final Logger LOG = Logger.getLogger(WaveformWriter.class.getName());
    private int byteOverlap;
    private int byteStepSize;

    public WaveformWriter(AudioFormat audioFormat, String string) {
        this.format = audioFormat;
        this.fileName = string;
        this.rawOutputFile = new File(System.getProperty("java.io.tmpdir"), new Random().nextInt() + "out.raw");
        try {
            this.rawOutputStream = new FileOutputStream(this.rawOutputFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string2 = String.format("Could not write to the temporary RAW file %1s: %2s", this.rawOutputFile.getAbsolutePath(), fileNotFoundException.getMessage());
            LOG.severe(string2);
        }
    }

    public WaveformWriter(TarsosDSPAudioFormat tarsosDSPAudioFormat, String string) {
        this(JVMAudioInputStream.toAudioFormat(tarsosDSPAudioFormat), string);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        this.byteOverlap = audioEvent.getOverlap() * this.format.getFrameSize();
        this.byteStepSize = audioEvent.getBufferSize() * this.format.getFrameSize() - this.byteOverlap;
        try {
            this.rawOutputStream.write(audioEvent.getByteBuffer(), this.byteOverlap, this.byteStepSize);
        }
        catch (IOException iOException) {
            LOG.severe(String.format("Failure while writing temporary file: %1s: %2s", this.rawOutputFile.getAbsolutePath(), iOException.getMessage()));
        }
        return true;
    }

    @Override
    public void processingFinished() {
        File file = new File(this.fileName);
        try {
            FileInputStream fileInputStream = new FileInputStream(this.rawOutputFile);
            long l = this.rawOutputFile.length() / (long)this.format.getFrameSize();
            AudioInputStream audioInputStream = new AudioInputStream(fileInputStream, this.format, l);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            AudioSystem.write(audioInputStream, AudioFileFormat.Type.WAVE, fileOutputStream);
            fileOutputStream.close();
            audioInputStream.close();
            fileInputStream.close();
            this.rawOutputStream.close();
            this.rawOutputFile.delete();
        }
        catch (IOException iOException) {
            String string = String.format("Error writing the WAV file %1s: %2s", file.getAbsolutePath(), iOException.getMessage());
            LOG.severe(string);
        }
    }
}

