/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.mfcc;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class DCT {
    int[][] f;
    int[][] g;
    int[][] inv;

    public static void main(String[] stringArray) {
        Object object;
        int[][] nArray = new int[8][8];
        if (stringArray.length != 1) {
            System.out.println("usage: java DCT <matrix-filename>");
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.canRead()) {
            System.out.println("Error! can't open " + stringArray[0] + " for reading");
            return;
        }
        try {
            object = new BufferedReader(new FileReader(file));
            for (int i = 0; i < 8; ++i) {
                String string = ((BufferedReader)object).readLine();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
                if (stringTokenizer.countTokens() != 8) {
                    System.out.println("Error! File format error: 8 tokens required!");
                    throw new IOException("Error");
                }
                for (int j = 0; j < 8; ++j) {
                    int n;
                    String string2 = stringTokenizer.nextToken();
                    nArray[i][j] = n = Integer.parseInt(string2);
                }
            }
            ((BufferedReader)object).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Error! can't create FileReader for " + stringArray[0]);
            return;
        }
        catch (IOException iOException) {
            System.out.println("Error! during read of " + stringArray[0]);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            System.out.println("Error! NumberFormatExecption");
            return;
        }
        object = new DCT(nArray);
        ((DCT)object).transform();
        ((DCT)object).printout();
        ((DCT)object).inverse();
        ((DCT)object).printoutinv();
    }

    public DCT(int[][] nArray) {
        this.f = nArray;
    }

    public void transform() {
        this.g = new int[8][8];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                double d;
                double d2 = 0.0;
                for (int k = 0; k < 8; ++k) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        d = (2.0 * (double)k + 1.0) * (double)i * Math.PI / 16.0;
                        double d3 = (2.0 * (double)i2 + 1.0) * (double)j * Math.PI / 16.0;
                        d2 += (double)this.f[k][i2] * Math.cos(d) * Math.cos(d3);
                    }
                }
                double d4 = i == 0 ? 1.0 / Math.sqrt(2.0) : 1.0;
                d = j == 0 ? 1.0 / Math.sqrt(2.0) : 1.0;
                this.g[i][j] = (int)Math.round(d2 *= d4 * d * 0.25);
            }
        }
    }

    public void inverse() {
        this.inv = new int[8][8];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                double d = 0.0;
                for (int k = 0; k < 8; ++k) {
                    double d2 = (2.0 * (double)i + 1.0) * (double)k * Math.PI / 16.0;
                    double d3 = k == 0 ? 1.0 / Math.sqrt(2.0) : 1.0;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double d4 = (2.0 * (double)j + 1.0) * (double)i2 * Math.PI / 16.0;
                        double d5 = i2 == 0 ? 1.0 / Math.sqrt(2.0) : 1.0;
                        double d6 = d3 * d5 * 0.25;
                        d += d6 * Math.cos(d2) * Math.cos(d4) * (double)this.g[k][i2];
                    }
                }
                this.inv[i][j] = (int)Math.round(d);
            }
        }
    }

    public void printout() {
        for (int i = 0; i < 8; ++i) {
            System.out.print("\n");
            for (int j = 0; j < 8; ++j) {
                System.out.print(this.g[i][j] + " ");
            }
        }
    }

    public void printoutinv() {
        for (int i = 0; i < 8; ++i) {
            System.out.print("\n");
            for (int j = 0; j < 8; ++j) {
                System.out.print(this.inv[i][j] + " ");
            }
        }
    }
}

