/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.mfcc;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HammingWindow;

public class MFCC
implements AudioProcessor {
    private int amountOfCepstrumCoef;
    protected int amountOfMelFilters;
    protected float lowerFilterFreq;
    protected float upperFilterFreq;
    float[] audioFloatBuffer;
    private float[] mfcc;
    int[] centerFrequencies;
    private FFT fft;
    private int samplesPerFrame;
    private float sampleRate;

    public MFCC(int n, int n2) {
        this(n, n2, 30, 30, 133.3334f, (float)n2 / 2.0f);
    }

    public MFCC(int n, float f, int n2, int n3, float f2, float f3) {
        this.samplesPerFrame = n;
        this.sampleRate = f;
        this.amountOfCepstrumCoef = n2;
        this.amountOfMelFilters = n3;
        this.fft = new FFT(n, new HammingWindow());
        this.lowerFilterFreq = Math.max(f2, 25.0f);
        this.upperFilterFreq = Math.min(f3, f / 2.0f);
        this.calculateFilterBanks();
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        this.audioFloatBuffer = (float[])audioEvent.getFloatBuffer().clone();
        float[] fArray = this.magnitudeSpectrum(this.audioFloatBuffer);
        float[] fArray2 = this.melFilter(fArray, this.centerFrequencies);
        float[] fArray3 = this.nonLinearTransformation(fArray2);
        this.mfcc = this.cepCoefficients(fArray3);
        return true;
    }

    @Override
    public void processingFinished() {
    }

    public float[] magnitudeSpectrum(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        this.fft.forwardTransform(fArray);
        for (int i = 0; i < fArray.length / 2; ++i) {
            fArray2[fArray.length / 2 + i] = this.fft.modulus(fArray, fArray.length / 2 - 1 - i);
            fArray2[fArray.length / 2 - 1 - i] = fArray2[fArray.length / 2 + i];
        }
        return fArray2;
    }

    public final void calculateFilterBanks() {
        this.centerFrequencies = new int[this.amountOfMelFilters + 2];
        this.centerFrequencies[0] = Math.round(this.lowerFilterFreq / this.sampleRate * (float)this.samplesPerFrame);
        this.centerFrequencies[this.centerFrequencies.length - 1] = this.samplesPerFrame / 2;
        double[] dArray = new double[]{MFCC.freqToMel(this.lowerFilterFreq), MFCC.freqToMel(this.upperFilterFreq)};
        float f = (float)((dArray[1] - dArray[0]) / (double)(this.amountOfMelFilters + 1));
        for (int i = 1; i <= this.amountOfMelFilters; ++i) {
            float f2 = MFCC.inverseMel(dArray[0] + (double)(f * (float)i)) / this.sampleRate * (float)this.samplesPerFrame;
            this.centerFrequencies[i - 1] = Math.round(f2);
        }
    }

    public float[] nonLinearTransformation(float[] fArray) {
        float[] fArray2 = new float[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            fArray2[i] = (float)Math.log(fArray[i]);
            if (!(fArray2[i] < -50.0f)) continue;
            fArray2[i] = -50.0f;
        }
        return fArray2;
    }

    public float[] melFilter(float[] fArray, int[] nArray) {
        float[] fArray2 = new float[this.amountOfMelFilters + 2];
        for (int i = 1; i <= this.amountOfMelFilters; ++i) {
            int n;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = nArray[i] - nArray[i - 1] + 1;
            for (n = nArray[i - 1]; n <= nArray[i]; ++n) {
                f += fArray[n] * (float)(n - nArray[i - 1] + 1);
            }
            f /= f3;
            f3 = nArray[i + 1] - nArray[i] + 1;
            for (n = nArray[i] + 1; n <= nArray[i + 1]; ++n) {
                f2 += fArray[n] * (1.0f - (float)(n - nArray[i]) / f3);
            }
            fArray2[i] = f + f2;
        }
        float[] fArray3 = new float[this.amountOfMelFilters];
        for (int i = 0; i < this.amountOfMelFilters; ++i) {
            fArray3[i] = fArray2[i + 1];
        }
        return fArray3;
    }

    public float[] cepCoefficients(float[] fArray) {
        float[] fArray2 = new float[this.amountOfCepstrumCoef];
        for (int i = 0; i < fArray2.length; ++i) {
            for (int j = 0; j < fArray.length; ++j) {
                int n = i;
                fArray2[n] = (float)((double)fArray2[n] + (double)fArray[j] * Math.cos(Math.PI * (double)i / (double)fArray.length * ((double)j + 0.5)));
            }
        }
        return fArray2;
    }

    protected static float freqToMel(float f) {
        return 2595.0f * MFCC.log10(1.0f + f / 700.0f);
    }

    private static float inverseMel(double d) {
        return (float)(700.0 * (Math.pow(10.0, d / 2595.0) - 1.0));
    }

    protected static float log10(float f) {
        return (float)(Math.log(f) / Math.log(10.0));
    }

    public float[] getMFCC() {
        return (float[])this.mfcc.clone();
    }

    public int[] getCenterFrequencies() {
        return this.centerFrequencies;
    }
}

