/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.onsets;

import be.tarsos.dsp.AudioDispatcher;
import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.beatroot.Peaks;
import be.tarsos.dsp.onsets.OnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.onsets.PrintOnsetHandler;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.ScaledHammingWindow;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;

public class BeatRootSpectralFluxOnsetDetector
implements AudioProcessor,
OnsetDetector {
    private double frameRMS;
    private int frameCount;
    private double ltAverage;
    private float[] reBuffer;
    private float[] imBuffer;
    private double[] spectralFlux;
    private int[] freqMap;
    private int freqMapSize;
    private float[] prevFrame;
    private double[] newFrame;
    private double[][] frames;
    private double[] energy;
    protected int hopSize;
    protected int fftSize;
    private int totalFrames;
    public static double silenceThreshold = 4.0E-4;
    public static double rangeThreshold = 10.0;
    public static int normaliseMode = 2;
    public static int energyOversampleFactor = 2;
    private OnsetHandler handler;
    private double hopTime;
    private final FFT fft;

    public BeatRootSpectralFluxOnsetDetector(AudioDispatcher audioDispatcher, int n, int n2) {
        this.hopSize = n2;
        this.hopTime = (float)n2 / audioDispatcher.getFormat().getSampleRate();
        this.fftSize = n;
        System.err.println("Please use the ComplexOnset detector: BeatRootSpectralFluxOnsetDetector does currenlty not support streaming");
        int n3 = -1000;
        this.totalFrames = n3 / n2 + 4;
        this.energy = new double[this.totalFrames * energyOversampleFactor];
        this.spectralFlux = new double[this.totalFrames];
        this.reBuffer = new float[n / 2];
        this.imBuffer = new float[n / 2];
        this.prevFrame = new float[n / 2];
        this.makeFreqMap(n, audioDispatcher.getFormat().getSampleRate());
        this.newFrame = new double[this.freqMapSize];
        this.frames = new double[this.totalFrames][this.freqMapSize];
        this.handler = new PrintOnsetHandler();
        this.fft = new FFT(n, new ScaledHammingWindow());
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        int n;
        int n2;
        this.frameRMS = audioEvent.getRMS() / 2.0;
        float[] fArray = (float[])audioEvent.getFloatBuffer().clone();
        Arrays.fill(this.imBuffer, 0.0f);
        this.fft.powerPhaseFFTBeatRootOnset(fArray, this.reBuffer, this.imBuffer);
        Arrays.fill(this.newFrame, 0.0);
        double d = 0.0;
        for (n2 = 0; n2 < this.fftSize / 2; ++n2) {
            if (this.reBuffer[n2] > this.prevFrame[n2]) {
                d += (double)(this.reBuffer[n2] - this.prevFrame[n2]);
            }
            int n3 = this.freqMap[n2];
            this.newFrame[n3] = this.newFrame[n3] + (double)this.reBuffer[n2];
        }
        this.spectralFlux[this.frameCount] = d;
        for (n2 = 0; n2 < this.freqMapSize; ++n2) {
            this.frames[this.frameCount][n2] = this.newFrame[n2];
        }
        n2 = (this.fftSize - this.hopSize) / energyOversampleFactor;
        int n4 = this.hopSize;
        for (int i = 0; i < energyOversampleFactor; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < n2; ++j) {
                d2 += (double)(fArray[n4] * fArray[n4]);
                if (++n4 != this.fftSize) continue;
                n4 = 0;
            }
            this.energy[this.frameCount * BeatRootSpectralFluxOnsetDetector.energyOversampleFactor + i] = d2 / (double)n2 <= 1.0E-6 ? 0.0 : Math.log(d2 / (double)n2) + 13.816;
        }
        double d3 = this.frameCount >= 200 ? 0.99 : (this.frameCount < 100 ? 0.0 : (double)(this.frameCount - 100) / 100.0);
        this.ltAverage = this.ltAverage == 0.0 ? this.frameRMS : this.ltAverage * d3 + this.frameRMS * (1.0 - d3);
        if (this.frameRMS <= silenceThreshold) {
            for (n = 0; n < this.freqMapSize; ++n) {
                this.frames[this.frameCount][n] = 0.0;
            }
        } else {
            if (normaliseMode == 1) {
                n = 0;
                while (n < this.freqMapSize) {
                    double[] dArray = this.frames[this.frameCount];
                    int n5 = n++;
                    dArray[n5] = dArray[n5] / this.frameRMS;
                }
            } else if (normaliseMode == 2) {
                n = 0;
                while (n < this.freqMapSize) {
                    double[] dArray = this.frames[this.frameCount];
                    int n6 = n++;
                    dArray[n6] = dArray[n6] / this.ltAverage;
                }
            }
            for (n = 0; n < this.freqMapSize; ++n) {
                this.frames[this.frameCount][n] = Math.log(this.frames[this.frameCount][n]) + rangeThreshold;
                if (!(this.frames[this.frameCount][n] < 0.0)) continue;
                this.frames[this.frameCount][n] = 0.0;
            }
        }
        float[] fArray2 = this.prevFrame;
        this.prevFrame = this.reBuffer;
        this.reBuffer = fArray2;
        ++this.frameCount;
        return true;
    }

    protected void makeFreqMap(int n, float f) {
        this.freqMap = new int[n / 2 + 1];
        double d = f / (float)n;
        int n2 = (int)(2.0 / (Math.pow(2.0, 0.08333333333333333) - 1.0));
        int n3 = (int)Math.round(Math.log((double)n2 * d / 440.0) / Math.log(2.0) * 12.0 + 69.0);
        int n4 = 0;
        while (n4 <= n2) {
            this.freqMap[n4++] = n4;
        }
        while (n4 <= n / 2) {
            double d2 = Math.log((double)n4 * d / 440.0) / Math.log(2.0) * 12.0 + 69.0;
            if (d2 > 127.0) {
                d2 = 127.0;
            }
            this.freqMap[n4++] = n2 + (int)Math.round(d2) - n3;
        }
        this.freqMapSize = this.freqMap[n4 - 1] + 1;
    }

    private void findOnsets(double d, double d2) {
        LinkedList<Integer> linkedList = Peaks.findPeaks(this.spectralFlux, (int)Math.round(0.06 / this.hopTime), d, d2, true);
        Iterator iterator = linkedList.iterator();
        double d3 = Peaks.min(this.spectralFlux);
        for (int i = 0; i < linkedList.size(); ++i) {
            int n = (Integer)iterator.next();
            double d4 = (double)n * this.hopTime;
            double d5 = this.spectralFlux[n] - d3;
            this.handler.handleOnset(d4, d5);
        }
    }

    @Override
    public void setHandler(OnsetHandler onsetHandler) {
        this.handler = onsetHandler;
    }

    @Override
    public void processingFinished() {
        double d = 0.35;
        double d2 = 0.84;
        Peaks.normalise(this.spectralFlux);
        this.findOnsets(d, d2);
    }
}

