/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.onsets;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.onsets.OnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.onsets.PrintOnsetHandler;
import be.tarsos.dsp.util.PeakPicker;
import be.tarsos.dsp.util.fft.FFT;
import be.tarsos.dsp.util.fft.HannWindow;

public class ComplexOnsetDetector
implements AudioProcessor,
OnsetDetector {
    private final double silenceThreshold;
    private final double minimumInterOnsetInterval;
    private double lastOnset;
    private double lastOnsetValue;
    private final PeakPicker peakPicker;
    private OnsetHandler handler;
    private final FFT fft;
    private final float[] theta1;
    private final float[] theta2;
    private final float[] oldmag;
    private final float[] dev1;

    public ComplexOnsetDetector(int n, double d, double d2, double d3) {
        this.fft = new FFT(n, new HannWindow());
        this.silenceThreshold = d3;
        this.minimumInterOnsetInterval = d2;
        this.peakPicker = new PeakPicker(d);
        int n2 = n / 2 + 1;
        this.oldmag = new float[n2];
        this.dev1 = new float[n2];
        this.theta1 = new float[n2];
        this.theta2 = new float[n2];
        this.handler = new PrintOnsetHandler();
    }

    public ComplexOnsetDetector(int n) {
        this(n, 0.3);
    }

    public ComplexOnsetDetector(int n, double d) {
        this(n, d, 0.03);
    }

    public ComplexOnsetDetector(int n, double d, double d2) {
        this(n, d, d2, -70.0);
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        this.onsetDetection(audioEvent);
        return true;
    }

    private void onsetDetection(AudioEvent audioEvent) {
        int n;
        float[] fArray = (float[])audioEvent.getFloatBuffer().clone();
        float[] fArray2 = new float[fArray.length / 2];
        float[] fArray3 = new float[fArray.length / 2];
        this.fft.powerPhaseFFT(fArray, fArray2, fArray3);
        float f = 0.0f;
        for (n = 0; n < fArray2.length; ++n) {
            this.dev1[n] = 2.0f * this.theta1[n] - this.theta2[n];
            f = (float)((double)f + Math.sqrt(Math.abs(Math.pow(this.oldmag[n], 2.0) + Math.pow(fArray2[n], 2.0) - 2.0 * (double)this.oldmag[n] * (double)fArray2[n] * Math.cos(this.dev1[n] - fArray3[n]))));
            this.theta2[n] = this.theta1[n];
            this.theta1[n] = fArray3[n];
            this.oldmag[n] = fArray2[n];
        }
        this.lastOnsetValue = f;
        n = this.peakPicker.pickPeak(f) ? 1 : 0;
        if (n != 0) {
            if (audioEvent.isSilence(this.silenceThreshold)) {
                n = 0;
            } else {
                double d = (double)audioEvent.getOverlap() * 4.3 / (double)audioEvent.getSampleRate();
                double d2 = audioEvent.getTimeStamp() - d;
                if (d2 - this.lastOnset > this.minimumInterOnsetInterval) {
                    this.handler.handleOnset(d2, this.peakPicker.getLastPeekValue());
                    this.lastOnset = d2;
                }
            }
        }
    }

    @Override
    public void setHandler(OnsetHandler onsetHandler) {
        this.handler = onsetHandler;
    }

    public void setThreshold(double d) {
        this.peakPicker.setThreshold(d);
    }

    @Override
    public void processingFinished() {
    }
}

