/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.onsets;

import be.tarsos.dsp.AudioEvent;
import be.tarsos.dsp.AudioProcessor;
import be.tarsos.dsp.onsets.OnsetDetector;
import be.tarsos.dsp.onsets.OnsetHandler;
import be.tarsos.dsp.util.fft.FFT;

public class PercussionOnsetDetector
implements AudioProcessor,
OnsetDetector {
    public static final double DEFAULT_THRESHOLD = 8.0;
    public static final double DEFAULT_SENSITIVITY = 20.0;
    private final FFT fft;
    private final float[] priorMagnitudes;
    private final float[] currentMagnitudes;
    private float dfMinus1;
    private float dfMinus2;
    private OnsetHandler handler;
    private final float sampleRate;
    private long processedSamples;
    private final double sensitivity;
    private final double threshold;

    public PercussionOnsetDetector(float f, int n, int n2, OnsetHandler onsetHandler) {
        this(f, n, onsetHandler, 20.0, 8.0);
    }

    public PercussionOnsetDetector(float f, int n, OnsetHandler onsetHandler, double d, double d2) {
        this.fft = new FFT(n / 2);
        this.threshold = d2;
        this.sensitivity = d;
        this.priorMagnitudes = new float[n / 2];
        this.currentMagnitudes = new float[n / 2];
        this.handler = onsetHandler;
        this.sampleRate = f;
    }

    @Override
    public boolean process(AudioEvent audioEvent) {
        float[] fArray = audioEvent.getFloatBuffer();
        this.processedSamples += (long)fArray.length;
        this.processedSamples -= (long)audioEvent.getOverlap();
        this.fft.forwardTransform(fArray);
        this.fft.modulus(fArray, this.currentMagnitudes);
        int n = 0;
        for (int i = 0; i < this.currentMagnitudes.length; ++i) {
            double d;
            if (this.priorMagnitudes[i] > 0.0f && (d = 10.0 * Math.log10(this.currentMagnitudes[i] / this.priorMagnitudes[i])) >= this.threshold) {
                ++n;
            }
            this.priorMagnitudes[i] = this.currentMagnitudes[i];
        }
        if (this.dfMinus2 < this.dfMinus1 && this.dfMinus1 >= (float)n && (double)this.dfMinus1 > (100.0 - this.sensitivity) * (double)fArray.length / 200.0) {
            float f = (float)this.processedSamples / this.sampleRate;
            this.handler.handleOnset(f, -1.0);
        }
        this.dfMinus2 = this.dfMinus1;
        this.dfMinus1 = n;
        return true;
    }

    @Override
    public void processingFinished() {
    }

    @Override
    public void setHandler(OnsetHandler onsetHandler) {
        this.handler = onsetHandler;
    }
}

