/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

import be.tarsos.dsp.pitch.PitchDetectionResult;
import be.tarsos.dsp.pitch.PitchDetector;

public class AMDF
implements PitchDetector {
    private static final double DEFAULT_MIN_FREQUENCY = 82.0;
    private static final double DEFAULT_MAX_FREQUENCY = 1000.0;
    private static final double DEFAULT_RATIO = 5.0;
    private static final double DEFAULT_SENSITIVITY = 0.1;
    private final float sampleRate;
    private final double[] amd;
    private final long maxPeriod;
    private final long minPeriod;
    private final double ratio;
    private final double sensitivity;
    private final PitchDetectionResult result;

    public AMDF(float f, int n) {
        this(f, n, 82.0, 1000.0);
    }

    public AMDF(float f, int n, double d, double d2) {
        this.sampleRate = f;
        this.amd = new double[n];
        this.ratio = 5.0;
        this.sensitivity = 0.1;
        this.maxPeriod = Math.round((double)f / d + 0.5);
        this.minPeriod = Math.round((double)f / d2 + 0.5);
        this.result = new PitchDetectionResult();
    }

    @Override
    public PitchDetectionResult getPitch(float[] fArray) {
        int n;
        double d;
        int n2;
        int n3;
        int n4 = 0;
        float f = -1.0f;
        double d2 = Double.POSITIVE_INFINITY;
        double d3 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[]{};
        double[] dArray2 = new double[]{};
        double[] dArray3 = new double[]{};
        int n5 = fArray.length;
        for (n3 = 0; n3 < n5; ++n3) {
            dArray = new double[n5 - n3 + 1];
            dArray2 = new double[n5 - n3 + 1];
            n4 = 0;
            for (n2 = 0; n2 < n5 - n3; ++n2) {
                dArray[++n4] = fArray[n2];
            }
            n4 = 0;
            for (n2 = n3; n2 < n5; ++n2) {
                dArray2[++n4] = fArray[n2];
            }
            n2 = dArray.length;
            dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                dArray3[i] = dArray[i] - dArray2[i];
            }
            d = 0.0;
            for (n = 0; n < n2; ++n) {
                d += Math.abs(dArray3[n]);
            }
            this.amd[n3] = d;
        }
        for (n3 = (int)this.minPeriod; n3 < (int)this.maxPeriod; ++n3) {
            if (this.amd[n3] < d2) {
                d2 = this.amd[n3];
            }
            if (!(this.amd[n3] > d3)) continue;
            d3 = this.amd[n3];
        }
        n3 = (int)Math.round(this.sensitivity * (d3 - d2) + d2);
        for (n2 = (int)this.minPeriod; n2 <= (int)this.maxPeriod && this.amd[n2] > (double)n3; ++n2) {
        }
        d = this.minPeriod / 2L;
        d2 = this.amd[n2];
        n = n2;
        int n6 = n2;
        while ((double)n6 < (double)n2 + d && (long)n6 <= this.maxPeriod) {
            if (!(this.amd[++n6] < d2)) continue;
            d2 = this.amd[n6];
            n = n6;
        }
        if ((double)Math.round(this.amd[n] * this.ratio) < d3) {
            f = this.sampleRate / (float)n;
        }
        this.result.setPitch(f);
        this.result.setPitched(-1.0f != f);
        this.result.setProbability(-1.0f);
        return this.result;
    }
}

