/*
 * Decompiled with CFR 0.152.
 */
package be.tarsos.dsp.pitch;

public class DTMF {
    public static final double[] DTMF_FREQUENCIES = new double[]{697.0, 770.0, 852.0, 941.0, 1209.0, 1336.0, 1477.0, 1633.0};
    public static final char[][] DTMF_CHARACTERS = new char[][]{{'1', '2', '3', 'A'}, {'4', '5', '6', 'B'}, {'7', '8', '9', 'C'}, {'*', '0', '#', 'D'}};

    public static float[] generateDTMFTone(char c) {
        double d = -1.0;
        double d2 = -1.0;
        for (int i = 0; i < DTMF_CHARACTERS.length; ++i) {
            for (int j = 0; j < DTMF_CHARACTERS[i].length; ++j) {
                if (DTMF_CHARACTERS[i][j] != c) continue;
                d = DTMF_FREQUENCIES[i];
                d2 = DTMF_FREQUENCIES[j + 4];
            }
        }
        return DTMF.audioBufferDTMF(d, d2, 10240);
    }

    public static boolean isDTMFCharacter(char c) {
        double d = -1.0;
        double d2 = -1.0;
        for (int i = 0; i < DTMF_CHARACTERS.length; ++i) {
            for (int j = 0; j < DTMF_CHARACTERS[i].length; ++j) {
                if (DTMF_CHARACTERS[i][j] != c) continue;
                d = DTMF_FREQUENCIES[i];
                d2 = DTMF_FREQUENCIES[j + 4];
            }
        }
        return d != -1.0 && d2 != -1.0;
    }

    public static float[] audioBufferDTMF(double d, double d2, int n) {
        double d3 = Math.PI * 2 * d;
        double d4 = Math.PI * 2 * d2;
        float[] fArray = new float[n];
        for (int i = 0; i < fArray.length; ++i) {
            double d5 = (double)i / 44100.0;
            double d6 = 0.4 * Math.sin(d3 * d5);
            double d7 = 0.4 * Math.sin(d4 * d5);
            fArray[i] = (float)(d6 + d7);
        }
        return fArray;
    }
}

